/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.Namespaces;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.Parser;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.persistence.sifs.configuration.Attribute;
import org.infinispan.persistence.sifs.configuration.Element;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;

@Namespaces(value={@Namespace(root="soft-index-file-store"), @Namespace(uri="urn:infinispan:config:store:soft-index:*", root="soft-index-file-store")})
public class SoftIndexFileStoreConfigurationParser
implements ConfigurationParser {
    public static final String ROOT_ELEMENT = "soft-index-file-store";

    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case SOFT_INDEX_FILE_STORE: {
                this.parseSoftIndexFileStore(reader, (SoftIndexFileStoreConfigurationBuilder)builder.persistence().addStore(SoftIndexFileStoreConfigurationBuilder.class));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    public Namespace[] getNamespaces() {
        return ParseUtils.getNamespaceAnnotations(this.getClass());
    }

    private void parseSoftIndexFileStore(XMLExtendedStreamReader reader, SoftIndexFileStoreConfigurationBuilder builder) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            String attrName = reader.getAttributeLocalName(i);
            Attribute attribute = Attribute.forName(attrName);
            switch (attribute) {
                case OPEN_FILES_LIMIT: {
                    builder.openFilesLimit(Integer.parseInt(value));
                    continue block8;
                }
                case COMPACTION_THRESHOLD: {
                    builder.compactionThreshold(Double.parseDouble(value));
                    continue block8;
                }
                default: {
                    Parser.parseStoreAttribute((XMLExtendedStreamReader)reader, (int)i, (AbstractStoreConfigurationBuilder)builder);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DATA: {
                    this.parseData(reader, builder);
                    continue block9;
                }
                case INDEX: {
                    this.parseIndex(reader, builder);
                    continue block9;
                }
            }
            Parser.parseStoreElement((XMLExtendedStreamReader)reader, (StoreConfigurationBuilder)builder);
        }
    }

    private void parseData(XMLExtendedStreamReader reader, SoftIndexFileStoreConfigurationBuilder builder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    builder.dataLocation(value);
                    continue block5;
                }
                case MAX_FILE_SIZE: {
                    builder.maxFileSize(Integer.parseInt(value));
                    continue block5;
                }
                case SYNC_WRITES: {
                    builder.syncWrites(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }

    private void parseIndex(XMLExtendedStreamReader reader, SoftIndexFileStoreConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    builder.indexLocation(value);
                    continue block7;
                }
                case SEGMENTS: {
                    builder.indexSegments(Integer.parseInt(value));
                    continue block7;
                }
                case INDEX_QUEUE_LENGTH: {
                    builder.indexQueueLength(Integer.parseInt(value));
                    continue block7;
                }
                case MIN_NODE_SIZE: {
                    builder.minNodeSize(Integer.parseInt(value));
                    continue block7;
                }
                case MAX_NODE_SIZE: {
                    builder.maxNodeSize(Integer.parseInt(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLStreamReader)reader);
    }
}

