/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetOperationType;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5312)
public final class CountFunction<K, V, T>
implements SortedSetBucketBaseFunction<K, V, Long> {
    private final T min;
    private final T max;
    private final boolean includeMin;
    private final boolean includeMax;
    private final SortedSetOperationType countType;

    public CountFunction(T min, boolean includeMin, T max, boolean includeMax, SortedSetOperationType countType) {
        this.min = min;
        this.includeMin = includeMin;
        this.max = max;
        this.includeMax = includeMax;
        this.countType = countType;
    }

    @ProtoFactory
    CountFunction(MarshallableObject<T> min, boolean includeMin, MarshallableObject<T> max, boolean includeMax, SortedSetOperationType countType) {
        this(MarshallableObject.unwrap(min), includeMin, MarshallableObject.unwrap(max), includeMax, countType);
    }

    @ProtoField(value=1)
    MarshallableObject<T> getMin() {
        return MarshallableObject.create(this.min);
    }

    @ProtoField(value=2)
    boolean isIncludeMin() {
        return this.includeMin;
    }

    @ProtoField(value=3)
    MarshallableObject<T> getMax() {
        return MarshallableObject.create(this.max);
    }

    @ProtoField(value=4)
    boolean isIncludeMax() {
        return this.includeMax;
    }

    @ProtoField(value=5)
    SortedSetOperationType getCountType() {
        return this.countType;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        long count = 0L;
        if (existing.isPresent()) {
            switch (this.countType) {
                case LEX: {
                    return ((SortedSetBucket)existing.get()).subset(this.min, this.includeMin, this.max, this.includeMax, false, null, null).size();
                }
                case SCORE: {
                    return ((SortedSetBucket)existing.get()).subset((Double)this.min, this.includeMin, (Double)this.max, this.includeMax, false, (Long)null, (Long)null).size();
                }
            }
        }
        return count;
    }
}

