/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.list;

import java.util.Optional;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.multimap.impl.ListBucket;
import org.infinispan.multimap.impl.function.list.ListBucketBaseFunction;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5329)
public final class RemoveCountFunction<K, V>
implements ListBucketBaseFunction<K, V, Long> {
    @ProtoField(value=1)
    final long count;
    private final V element;

    public RemoveCountFunction(long count, V element) {
        this.count = count;
        this.element = element;
    }

    @ProtoFactory
    RemoveCountFunction(long count, MarshallableObject<V> element) {
        this(count, MarshallableObject.unwrap(element));
    }

    @ProtoField(value=2)
    MarshallableObject<V> getElement() {
        return MarshallableObject.create(this.element);
    }

    public Long apply(EntryView.ReadWriteEntryView<K, ListBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            ListBucket prevBucket = (ListBucket)existing.get();
            ListBucket.ListBucketResult<Long, V> result = prevBucket.remove(this.count, this.element);
            if (result.bucket().isEmpty()) {
                entryView.remove();
                return result.result();
            }
            entryView.set(result.bucket(), new MetaParam.Writable[0]);
            return result.result();
        }
        return 0L;
    }
}

