/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.commons.util.Util;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortableBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=5302)
public class ListBucket<V>
implements SortableBucket<V> {
    final Deque<V> values;

    public ListBucket() {
        this.values = new ArrayDeque<V>(0);
    }

    public ListBucket(V value) {
        ArrayDeque<V> deque = new ArrayDeque<V>(1);
        deque.add(value);
        this.values = deque;
    }

    private ListBucket(Deque<V> values) {
        this.values = values;
    }

    public static <V> ListBucket<V> create(Collection<V> value) {
        return new ListBucket<V>(new ArrayDeque<V>(value));
    }

    @ProtoFactory
    ListBucket(Collection<MarshallableUserObject<V>> wrappedValues) {
        this(wrappedValues.stream().map(rec$ -> rec$.get()).collect(Collectors.toCollection(ArrayDeque::new)));
    }

    @ProtoField(number=1, collectionImplementation=ArrayList.class)
    Collection<MarshallableUserObject<V>> getWrappedValues() {
        return this.values.stream().map(MarshallableUserObject::new).collect(Collectors.toCollection(ArrayDeque::new));
    }

    public boolean contains(V value) {
        for (V v : this.values) {
            if (!Objects.deepEquals(v, value)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public long size() {
        return this.values.size();
    }

    public Deque<V> toDeque() {
        return new ArrayDeque<V>(this.values);
    }

    public String toString() {
        return "ListBucket{values=" + Util.toStr(this.values) + "}";
    }

    public ListBucket<V> offer(Collection<V> value, boolean first) {
        ArrayDeque<V> newItems = new ArrayDeque<V>(this.values);
        if (first) {
            for (V v : value) {
                newItems.offerFirst(v);
            }
        } else {
            for (V v : value) {
                newItems.offerLast(v);
            }
        }
        return new ListBucket<V>(newItems);
    }

    public ListBucket<V> set(long index, V value) {
        if (index >= 0L && (long)(this.values.size() - 1) < index || index < 0L && (long)this.values.size() + index < 0L) {
            return null;
        }
        ArrayDeque<V> newBucket = new ArrayDeque<V>(this.values.size());
        if (index >= 0L) {
            Iterator<V> ite = this.values.iterator();
            int currentIndex = 0;
            while (ite.hasNext()) {
                V element = ite.next();
                if (index == (long)currentIndex) {
                    newBucket.offerLast(value);
                } else {
                    newBucket.offerLast(element);
                }
                ++currentIndex;
            }
        } else {
            Iterator<V> ite = this.values.descendingIterator();
            int currentIndex = -1;
            while (ite.hasNext()) {
                V element = ite.next();
                if (index == (long)currentIndex) {
                    newBucket.offerFirst(value);
                } else {
                    newBucket.offerFirst(element);
                }
                --currentIndex;
            }
        }
        return new ListBucket(newBucket);
    }

    public Collection<V> sublist(long from, long to) {
        if (from > 0L && to > 0L && from > to || from < 0L && to < 0L && from > to) {
            return Collections.emptyList();
        }
        if (from == to) {
            V element = this.index(from);
            if (element != null) {
                return Collections.singletonList(element);
            }
            return Collections.emptyList();
        }
        ArrayList<V> result = new ArrayList<V>();
        long fromIte = from < 0L ? (long)this.values.size() + from : from;
        long toIte = to < 0L ? (long)this.values.size() + to : to;
        Iterator<V> ite = this.values.iterator();
        int offset = 0;
        while (ite.hasNext()) {
            V element = ite.next();
            if ((long)offset < fromIte) {
                ++offset;
                continue;
            }
            if ((long)offset > toIte) break;
            result.add(element);
            ++offset;
        }
        return result;
    }

    public ListBucket<V> trim(long from, long to) {
        long startRemoveCount;
        if (from > 0L && to > 0L && from > to || from < 0L && to < 0L && from > to) {
            return new ListBucket<V>();
        }
        if (from == to) {
            V element = this.index(from);
            return element != null ? new ListBucket<V>(element) : this;
        }
        long keepCount = (to < 0L ? (long)this.values.size() + to : to) - startRemoveCount;
        ArrayDeque<V> newValues = new ArrayDeque<V>(this.values);
        Iterator ite = newValues.iterator();
        for (startRemoveCount = from < 0L ? (long)this.values.size() + from : from; ite.hasNext() && startRemoveCount > 0L; --startRemoveCount) {
            ite.next();
            ite.remove();
        }
        while (ite.hasNext() && keepCount >= 0L) {
            ite.next();
            --keepCount;
        }
        while (ite.hasNext()) {
            ite.next();
            ite.remove();
        }
        return new ListBucket<V>(newValues);
    }

    public Collection<Long> indexOf(V element, long count, long rank, long maxLen) {
        long matches = count == 0L ? (long)this.values.size() : count;
        long rankCount = Math.abs(rank);
        long comparisons = maxLen == 0L ? (long)this.values.size() : maxLen;
        Iterator<V> ite = rank > 0L ? this.values.iterator() : this.values.descendingIterator();
        long pos = 0L;
        ArrayList<Long> positions = new ArrayList<Long>();
        while (ite.hasNext() && comparisons > 0L && matches > 0L) {
            V current = ite.next();
            if (Objects.deepEquals(element, current)) {
                if (rankCount == 1L) {
                    --matches;
                    if (rank < 0L) {
                        positions.add((long)this.values.size() - pos - 1L);
                    } else {
                        positions.add(pos);
                    }
                } else {
                    --rankCount;
                }
            }
            --comparisons;
            ++pos;
        }
        return positions;
    }

    public ListBucket<V> insert(boolean before, V pivot, V element) {
        ArrayDeque<V> newValues = new ArrayDeque<V>(this.values.size() + 1);
        Iterator<V> iterator = this.values.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            V next = iterator.next();
            if (found) {
                newValues.offerLast(next);
                continue;
            }
            if (Objects.deepEquals(pivot, next)) {
                found = true;
                if (before) {
                    newValues.offerLast(element);
                    newValues.offerLast(next);
                    continue;
                }
                newValues.offerLast(next);
                newValues.offerLast(element);
                continue;
            }
            newValues.offerLast(next);
        }
        if (!found) {
            return null;
        }
        return new ListBucket(newValues);
    }

    public ListBucketResult<Long, V> remove(long count, V element) {
        Iterator<V> ite = count < 0L ? this.values.descendingIterator() : this.values.iterator();
        long maxRemovalsCount = count == 0L ? (long)this.values.size() : Math.abs(count);
        long removedElements = 0L;
        ArrayDeque<V> newItems = new ArrayDeque<V>();
        while (ite.hasNext()) {
            V next = ite.next();
            if (Objects.deepEquals(next, element) && removedElements < maxRemovalsCount) {
                ++removedElements;
                continue;
            }
            if (count < 0L) {
                newItems.addFirst(next);
                continue;
            }
            newItems.addLast(next);
        }
        return new ListBucketResult(removedElements, new ListBucket(newItems));
    }

    public ListBucketResult<V, V> rotate(boolean rotateRight) {
        Object element;
        ArrayDeque<V> newItems = new ArrayDeque<V>(this.values);
        if (rotateRight) {
            element = newItems.pollFirst();
            newItems.offerLast(element);
        } else {
            element = newItems.pollLast();
            newItems.offerFirst(element);
        }
        return new ListBucketResult(element, new ListBucket<V>(newItems));
    }

    @Override
    public Stream<MultimapObjectWrapper<V>> stream() {
        return this.values.stream().map(MultimapObjectWrapper::new);
    }

    @Override
    public List<ScoredValue<V>> sort(SortableBucket.SortOptions sortOptions) {
        Stream scoredValueStream = sortOptions.alpha ? this.values.stream().map(v -> {
            MultimapObjectWrapper<Object> wrapped = new MultimapObjectWrapper<Object>(v);
            return new ScoredValue<Object>(1.0, wrapped);
        }) : this.values.stream().map(v -> {
            MultimapObjectWrapper<Object> wrapped = new MultimapObjectWrapper<Object>(v);
            return new ScoredValue<Object>(wrapped.asDouble(), wrapped);
        });
        return this.sort(scoredValueStream, sortOptions);
    }

    public ListBucket<V> replace(Deque<V> list) {
        if (list != null && !list.isEmpty()) {
            return new ListBucket<V>(list);
        }
        return new ListBucket<V>();
    }

    public ListBucketResult<Collection<V>, V> poll(boolean first, long count) {
        ArrayList<Object> polledValues = new ArrayList<Object>();
        if (count >= (long)this.values.size()) {
            if (first) {
                polledValues.addAll(this.values);
            } else {
                Iterator<V> ite = this.values.descendingIterator();
                while (ite.hasNext()) {
                    polledValues.add(ite.next());
                }
            }
            return new ListBucketResult(polledValues, new ListBucket<V>());
        }
        ArrayDeque<V> newItems = new ArrayDeque<V>(this.values);
        int i = 0;
        while ((long)i < count) {
            if (first) {
                polledValues.add(newItems.pollFirst());
            } else {
                polledValues.add(newItems.pollLast());
            }
            ++i;
        }
        return new ListBucketResult(polledValues, new ListBucket<V>(newItems));
    }

    public V index(long index) {
        if (index == 0L) {
            return this.values.element();
        }
        if (index == (long)(this.values.size() - 1) || index == -1L) {
            return this.values.getLast();
        }
        V result = null;
        if (index > 0L) {
            if (index >= (long)this.values.size()) {
                return null;
            }
            Iterator<V> iterator = this.values.iterator();
            int currentIndex = 0;
            while ((long)currentIndex++ <= index) {
                result = iterator.next();
            }
        } else {
            long currentIndex = Math.abs(index);
            if (currentIndex > (long)this.values.size()) {
                return null;
            }
            Iterator<V> iterator = this.values.descendingIterator();
            while (currentIndex-- > 0L) {
                result = iterator.next();
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        try {
            ListBucket that = (ListBucket)o;
            if (this.values.size() != that.values.size()) {
                return false;
            }
            for (V value : this.values) {
                if (that.contains(value)) continue;
                return false;
            }
        }
        catch (ClassCastException ignore) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public record ListBucketResult<R, E>(R result, ListBucket<E> bucket) {
    }
}

