/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapKeySetFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapPutFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapRemoveFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapReplaceFunction;
import org.infinispan.multimap.impl.function.hmap.HashMapValuesFunction;

public class EmbeddedMultimapPairCache<K, HK, HV> {
    public static final String ERR_KEY_CAN_T_BE_NULL = "key can't be null";
    public static final String ERR_PROPERTY_CANT_BE_NULL = "property can't be null";
    public static final String ERR_VALUE_CANT_BE_NULL = "property value can't be null";
    public static final String ERR_PROPERTIES_CANT_BE_EMPTY = "properties can't be empty";
    public static final String ERR_COUNT_MUST_BE_POSITIVE = "count must be positive";
    private final FunctionalMap.ReadWriteMap<K, HashMapBucket<HK, HV>> readWriteMap;
    private final AdvancedCache<K, HashMapBucket<HK, HV>> cache;

    public EmbeddedMultimapPairCache(Cache<K, HashMapBucket<HK, HV>> cache) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
    }

    @SafeVarargs
    public final CompletionStage<Integer> set(K key, Map.Entry<HK, HV> ... entries) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        ArrayList<Map.Entry<HK, HV>> values = new ArrayList<Map.Entry<HK, HV>>(Arrays.asList(entries));
        return this.readWriteMap.eval(key, new HashMapPutFunction(values));
    }

    public final CompletionStage<Boolean> setIfAbsent(K key, HK propertyKey, HV propertyValue) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(propertyKey, ERR_PROPERTY_CANT_BE_NULL);
        Objects.requireNonNull(propertyValue, ERR_VALUE_CANT_BE_NULL);
        return this.readWriteMap.eval(key, new HashMapPutFunction(List.of(Map.entry(propertyKey, propertyValue)), true)).thenApply(v -> (long)v.intValue() > 0L);
    }

    public CompletionStage<Map<HK, HV>> get(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return Map.of();
            }
            HashMapBucket bucket = (HashMapBucket)entry.getValue();
            return bucket.converted();
        });
    }

    public CompletionStage<HV> get(K key, HK property) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(property, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return null;
            }
            HashMapBucket bucket = (HashMapBucket)entry.getValue();
            return bucket.get(property);
        });
    }

    @SafeVarargs
    public final CompletionStage<Map<HK, HV>> get(K key, HK ... properties) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(properties, ERR_PROPERTY_CANT_BE_NULL);
        EmbeddedMultimapPairCache.requireTrue(properties.length > 0, ERR_PROPERTIES_CANT_BE_EMPTY);
        Set propertySet = Set.of(properties);
        EmbeddedMultimapPairCache.requireNonNullArgument(propertySet, ERR_PROPERTY_CANT_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return Map.of();
            }
            HashMapBucket bucket = (HashMapBucket)entry.getValue();
            return bucket.getAll(propertySet);
        });
    }

    public CompletionStage<Integer> size(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return 0;
            }
            HashMapBucket bucket = (HashMapBucket)entry.getValue();
            return bucket.size();
        });
    }

    public CompletionStage<Set<HK>> keySet(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, HashMapKeySetFunction.instance());
    }

    public CompletionStage<Collection<HV>> values(K key) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        return this.readWriteMap.eval(key, HashMapValuesFunction.instance());
    }

    public CompletionStage<Boolean> contains(K key, HK property) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(property, ERR_PROPERTY_CANT_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return false;
            }
            HashMapBucket bucket = (HashMapBucket)entry.getValue();
            return bucket.containsKey(property);
        });
    }

    @SafeVarargs
    public final CompletionStage<Integer> remove(K key, HK property, HK ... properties) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(property, ERR_PROPERTY_CANT_BE_NULL);
        ArrayList<HK> propertiesList = new ArrayList<HK>();
        propertiesList.add(property);
        propertiesList.addAll(Arrays.asList(properties));
        return this.readWriteMap.eval(key, new HashMapRemoveFunction(propertiesList));
    }

    public final CompletionStage<Integer> remove(K key, Collection<HK> properties) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(properties, ERR_PROPERTY_CANT_BE_NULL);
        if (properties.isEmpty()) {
            return CompletableFuture.completedFuture(0);
        }
        return this.readWriteMap.eval(key, new HashMapRemoveFunction(properties));
    }

    public CompletionStage<HV> compute(K key, HK property, BiFunction<HK, HV, HV> biConsumer) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        Objects.requireNonNull(property, ERR_PROPERTY_CANT_BE_NULL);
        return this.cache.getCacheEntryAsync(key).thenCompose(entry -> {
            Object oldValue = null;
            if (entry != null) {
                oldValue = ((HashMapBucket)entry.getValue()).get(property);
            }
            Object newValue = biConsumer.apply(property, oldValue);
            CompletableFuture done = this.readWriteMap.eval(key, new HashMapReplaceFunction(property, oldValue, newValue));
            return done.thenCompose(replaced -> {
                if (replaced.booleanValue()) {
                    return CompletableFuture.completedFuture(newValue);
                }
                return this.compute(key, property, biConsumer);
            });
        });
    }

    public CompletionStage<Map<HK, HV>> subSelect(K key, int count) {
        Objects.requireNonNull(key, ERR_KEY_CAN_T_BE_NULL);
        EmbeddedMultimapPairCache.requirePositive(count, ERR_COUNT_MUST_BE_POSITIVE);
        return this.cache.getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return null;
            }
            Map converted = ((HashMapBucket)entry.getValue()).converted();
            if (count >= converted.size()) {
                return converted;
            }
            ArrayList entries = new ArrayList(converted.entrySet());
            Collections.shuffle(entries, ThreadLocalRandom.current());
            return entries.stream().limit(count).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        });
    }

    private static void requirePositive(int value, String message) {
        if (value <= 0) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void requireTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void requireNonNullArgument(Collection<?> arguments, String message) {
        for (Object argument : arguments) {
            Objects.requireNonNull(argument, message);
        }
    }
}

