/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.multimap.api.embedded.MultimapCache;
import org.infinispan.multimap.impl.Bucket;
import org.infinispan.multimap.impl.function.ContainsFunction;
import org.infinispan.multimap.impl.function.GetFunction;
import org.infinispan.multimap.impl.function.PutFunction;
import org.infinispan.multimap.impl.function.RemoveFunction;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.function.SerializableBiConsumer;
import org.infinispan.util.function.SerializableBiFunction;
import org.infinispan.util.function.SerializablePredicate;

public class EmbeddedMultimapCache<K, V>
implements MultimapCache<K, V> {
    private final FunctionalMap.ReadWriteMap<K, Bucket<V>> readWriteMap;
    private final AdvancedCache<K, Bucket<V>> cache;
    private final InternalEntryFactory entryFactory;

    public EmbeddedMultimapCache(Cache<K, Bucket<V>> cache) {
        this.cache = cache.getAdvancedCache();
        FunctionalMapImpl functionalMap = FunctionalMapImpl.create(this.cache);
        this.readWriteMap = ReadWriteMapImpl.create((FunctionalMapImpl)functionalMap);
        this.entryFactory = (InternalEntryFactory)this.cache.getComponentRegistry().getInternalEntryFactory().running();
    }

    public CompletableFuture<Void> put(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new PutFunction(value));
    }

    public CompletableFuture<Collection<V>> get(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new GetFunction());
    }

    @Override
    public CompletableFuture<Optional<CacheEntry<K, Collection<V>>>> getEntry(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.cache.getAdvancedCache().getCacheEntryAsync(key).thenApply(entry -> {
            if (entry == null) {
                return Optional.empty();
            }
            return Optional.of(this.entryFactory.create(entry.getKey(), ((Bucket)entry.getValue()).toSet(), entry.getMetadata()));
        });
    }

    public CompletableFuture<Boolean> remove(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new RemoveFunction());
    }

    public CompletableFuture<Boolean> remove(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new RemoveFunction(value));
    }

    @Override
    public CompletableFuture<Void> remove(Predicate<? super V> p) {
        Objects.requireNonNull(p, "predicate can't be null");
        try {
            return this.isExplicitTxContext() ? CompletableFuture.completedFuture(this.removeInternal(p)) : CompletableFuture.runAsync(() -> this.removeInternal(p));
        }
        catch (SystemException e) {
            throw CompletableFutures.asCompletionException((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> containsKey(K key) {
        Objects.requireNonNull(key, "key can't be null");
        return this.readWriteMap.eval(key, new ContainsFunction());
    }

    public CompletableFuture<Boolean> containsValue(V value) {
        Objects.requireNonNull(value, "value can't be null");
        try {
            return this.isExplicitTxContext() ? CompletableFuture.completedFuture(this.containsEntryInternal(value)) : CompletableFuture.supplyAsync(() -> this.containsEntryInternal(value));
        }
        catch (SystemException e) {
            throw CompletableFutures.asCompletionException((Throwable)e);
        }
    }

    public CompletableFuture<Boolean> containsEntry(K key, V value) {
        Objects.requireNonNull(key, "key can't be null");
        Objects.requireNonNull(value, "value can't be null");
        return this.readWriteMap.eval(key, new ContainsFunction(value));
    }

    public CompletableFuture<Long> size() {
        try {
            return this.isExplicitTxContext() ? CompletableFuture.completedFuture(this.sizeInternal()) : CompletableFuture.supplyAsync(this::sizeInternal);
        }
        catch (SystemException e) {
            throw CompletableFutures.asCompletionException((Throwable)e);
        }
    }

    private boolean isExplicitTxContext() throws SystemException {
        TransactionManager transactionManager = this.cache.getAdvancedCache().getTransactionManager();
        return transactionManager != null && transactionManager.getTransaction() != null;
    }

    private Void removeInternal(Predicate<? super V> p) {
        this.cache.keySet().stream().forEach((SerializableBiConsumer & Serializable)(c, key) -> c.computeIfPresent(key, (SerializableBiFunction & Serializable)(k, bucket) -> {
            Bucket newBucket = ((Bucket)bucket).removeIf(p);
            if (newBucket == null) {
                return bucket;
            }
            return newBucket.isEmpty() ? null : newBucket;
        }));
        return null;
    }

    private Boolean containsEntryInternal(V value) {
        return this.cache.entrySet().parallelStream().anyMatch((SerializablePredicate & Serializable)entry -> ((Bucket)entry.getValue()).contains(value));
    }

    private Long sizeInternal() {
        return this.cache.values().parallelStream().mapToLong(Bucket::size).sum();
    }

    public boolean supportsDuplicates() {
        return false;
    }

    public Cache<K, Bucket<V>> getCache() {
        return this.cache;
    }
}

