/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.Set;
import org.infinispan.jopr.ConnectionHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerComponent
implements ResourceComponent,
MeasurementFacet {
    private static final Log log = LogFactory.getLog(CacheManagerComponent.class);
    private ResourceContext context;
    private ConnectionHelper helper;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheManagerBean(conn);
            if (bean != null) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)"Cache manager could be found and attributes where refreshed, so it's up.", new Object[]{bean});
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)"Cache manager could not be found, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        this.helper = new ConnectionHelper();
        this.getConnection();
    }

    public void stop() {
        this.helper.closeConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Get values for these metrics: {0}", new Object[]{metrics});
        }
        EmsConnection conn = this.getConnection();
        if (trace) {
            log.trace((Object)"Connection to ems server stablished: {0}", new Object[]{conn});
        }
        EmsBean bean = this.queryCacheManagerBean(conn);
        bean.refreshAttributes();
        if (trace) {
            log.trace((Object)"Querying returned bean: {0}", new Object[]{bean});
        }
        for (MeasurementScheduleRequest req : metrics) {
            DataType type = req.getDataType();
            if (type == DataType.MEASUREMENT) {
                String tmp = (String)bean.getAttribute(req.getName()).getValue();
                Double val = Double.valueOf(tmp);
                if (trace) {
                    log.trace((Object)"Metric ({0}) is measurement with value {1}", new Object[]{req.getName(), val});
                }
                MeasurementDataNumeric res = new MeasurementDataNumeric(req, val);
                report.addData(res);
                continue;
            }
            if (type != DataType.TRAIT) continue;
            String value = (String)bean.getAttribute(req.getName()).getValue();
            if (trace) {
                log.trace((Object)"Metric ({0}) is trait with value {1}", new Object[]{req.getName(), value});
            }
            MeasurementDataTrait res = new MeasurementDataTrait(req, value);
            report.addData(res);
        }
    }

    protected EmsConnection getConnection() {
        EmsConnection conn = this.helper.getEmsConnection(this.context.getPluginConfiguration());
        return conn;
    }

    private EmsBean queryCacheManagerBean(EmsConnection conn) {
        String pattern = this.context.getPluginConfiguration().getSimpleValue("objectName", null);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Pattern to query is {0}", new Object[]{pattern});
        }
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(pattern);
        return (EmsBean)conn.queryBeans(queryUtility.getTranslatedQuery()).get(0);
    }
}

