/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr.infinispan;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.jopr.infinispan.ConnectionHelper;
import org.infinispan.jopr.infinispan.InfinispanComponent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class InfinispanDiscovery
implements ResourceDiscoveryComponent<InfinispanComponent> {
    public static String REMOTE = "service:jmx:rmi://127.0.0.1/jndi/rmi://127.0.0.1:6996/jmxrmi";
    public static String MANAGER_OBJECT = "*:cache-name=[global],jmx-resource=CacheManager";
    String connector = "org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<InfinispanComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        Configuration c = new Configuration();
        c.put((Property)new PropertySimple("connectorAddress", (Object)REMOTE));
        c.put((Property)new PropertySimple("type", (Object)this.connector));
        c.put((Property)new PropertySimple("objectName", (Object)MANAGER_OBJECT));
        ConnectionHelper helper = new ConnectionHelper();
        EmsConnection conn = helper.getEmsConnection(c);
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(MANAGER_OBJECT);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        for (EmsBean bean : beans) {
            String managerName = bean.getBeanName().getCanonicalName();
            c.put((Property)new PropertySimple("objectName", (Object)managerName));
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), managerName, "Infinispan Cache Manager", null, "The Infinispan Manager", c, null);
            discoveredResources.add(detail);
            this.log.info((Object)("Discovered Infinispan instance: " + managerName));
        }
        return discoveredResources;
    }
}

