/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemove;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCacheRemoveEntryInterceptor
implements Serializable {
    private static final long serialVersionUID = -9079291622309963969L;
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCacheRemoveEntryInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cacheRemoveEntry(InvocationContext invocationContext) throws Exception {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method named '%s'", (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheRemove cacheRemoveEntry = (CacheRemove)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        if (!cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Remove entry with key '%s' in cache '%s' before method invocation", (Object)cacheKey, (Object)cache.getName());
            }
        }
        Object result = invocationContext.proceed();
        if (cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Remove entry with key '%s' in cache '%s' after method invocation", (Object)cacheKey, (Object)cache.getName());
            }
        }
        return result;
    }

    protected abstract Log getLog();
}

