/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.jcache.annotation.Contracts;

@ApplicationScoped
public class DefaultCacheResolver
implements CacheResolver {
    private CacheManager defaultCacheManager;

    DefaultCacheResolver() {
        CachingProvider provider = Caching.getCachingProvider();
        this.defaultCacheManager = provider.getCacheManager(provider.getDefaultURI(), provider.getDefaultClassLoader());
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter must not be null");
        String cacheName = cacheInvocationContext.getCacheName();
        if (cacheName.trim().isEmpty()) {
            return this.defaultCacheManager.createCache(cacheName, (Configuration)new MutableConfiguration());
        }
        for (String name : this.defaultCacheManager.getCacheNames()) {
            if (!name.equals(cacheName)) continue;
            return this.defaultCacheManager.getCache(cacheName);
        }
        return this.defaultCacheManager.createCache(cacheName, (Configuration)new MutableConfiguration());
    }
}

