/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CompletionListener;
import javax.cache.management.CacheMXBean;
import javax.cache.management.CacheStatisticsMXBean;
import javax.management.MBeanServer;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jcache.JCacheEntry;
import org.infinispan.jcache.JCacheListenerAdapter;
import org.infinispan.jcache.JCacheLoaderAdapter;
import org.infinispan.jcache.JCacheManager;
import org.infinispan.jcache.JCacheNotifier;
import org.infinispan.jcache.JCacheWriterAdapter;
import org.infinispan.jcache.MutableJCacheEntry;
import org.infinispan.jcache.RICacheStatistics;
import org.infinispan.jcache.RIDelegatingCacheMXBean;
import org.infinispan.jcache.RIMBeanServerRegistrationUtility;
import org.infinispan.jcache.interceptor.ExpirationTrackingInterceptor;
import org.infinispan.jcache.logging.Log;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.manager.PersistenceManagerImpl;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.locks.containers.LockContainer;
import org.infinispan.util.concurrent.locks.containers.ReentrantPerEntryLockContainer;
import org.infinispan.util.logging.LogFactory;

public final class JCache<K, V>
implements Cache<K, V> {
    private static final Log log = (Log)LogFactory.getLog(JCache.class, Log.class);
    private final JCacheManager cacheManager;
    private final Configuration<K, V> configuration;
    private final AdvancedCache<K, V> cache;
    private final AdvancedCache<K, V> ignoreReturnValuesCache;
    private final AdvancedCache<K, V> skipCacheLoadCache;
    private final AdvancedCache<K, V> skipCacheLoadAndStatsCache;
    private final AdvancedCache<K, V> skipListenerCache;
    private final CacheStatisticsMXBean stats;
    private final CacheMXBean mxBean;
    private final ExpiryPolicy<? super K, ? super V> expiryPolicy;
    private final LockContainer processorLocks = new ReentrantPerEntryLockContainer(32);
    private final long lockTimeout;
    private CacheLoader<K, V> cacheLoader;

    public JCache(AdvancedCache<K, V> cache, JCacheManager cacheManager, Configuration<K, V> c) {
        this.cache = cache;
        this.ignoreReturnValuesCache = cache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES});
        this.skipCacheLoadCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD});
        this.skipCacheLoadAndStatsCache = cache.withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.SKIP_STATISTICS});
        this.skipListenerCache = cache.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION});
        this.cacheManager = cacheManager;
        this.configuration = new MutableConfiguration(c).setManagementEnabled(c.isManagementEnabled());
        this.mxBean = new RIDelegatingCacheMXBean(this);
        this.stats = new RICacheStatistics(this.cache);
        this.expiryPolicy = (ExpiryPolicy)this.configuration.getExpiryPolicyFactory().create();
        this.lockTimeout = cache.getCacheConfiguration().locking().lockAcquisitionTimeout();
        JCacheNotifier notifier = new JCacheNotifier();
        boolean hasListeners = false;
        for (CacheEntryListenerConfiguration r : c.getCacheEntryListenerConfigurations()) {
            notifier.addListener(r);
            hasListeners = true;
        }
        if (hasListeners) {
            cache.addListener(new JCacheListenerAdapter(this, notifier));
        }
        this.setCacheLoader(cache, c);
        this.setCacheWriter(cache, c);
        this.addExpirationTrackingInterceptor(cache, notifier);
        if (this.configuration.isManagementEnabled()) {
            this.setManagementEnabled(true);
        }
        if (this.configuration.isStatisticsEnabled()) {
            this.setStatisticsEnabled(true);
        }
    }

    private void setCacheLoader(AdvancedCache<K, V> cache, Configuration<K, V> c) {
        Factory cacheLoaderFactory = c.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)cache.getComponentRegistry().getComponent(PersistenceManager.class);
            JCacheLoaderAdapter ispnCacheLoader = (JCacheLoaderAdapter)persistenceManager.getAllLoaders().get(0);
            this.cacheLoader = (CacheLoader)cacheLoaderFactory.create();
            ispnCacheLoader.setCacheLoader(this.cacheLoader);
        }
    }

    private void setCacheWriter(AdvancedCache<K, V> cache, Configuration<K, V> c) {
        Factory cacheWriterFactory = c.getCacheWriterFactory();
        if (cacheWriterFactory != null) {
            PersistenceManagerImpl persistenceManager = (PersistenceManagerImpl)cache.getComponentRegistry().getComponent(PersistenceManager.class);
            JCacheWriterAdapter ispnCacheStore = (JCacheWriterAdapter)persistenceManager.getAllWriters().get(0);
            ispnCacheStore.setCacheWriter((CacheWriter)cacheWriterFactory.create());
        }
    }

    private void addExpirationTrackingInterceptor(AdvancedCache<K, V> cache, JCacheNotifier notifier) {
        ExpirationTrackingInterceptor interceptor = new ExpirationTrackingInterceptor(cache.getDataContainer(), this, notifier, cache.getComponentRegistry().getTimeService());
        cache.addInterceptorBefore((CommandInterceptor)interceptor, EntryWrappingInterceptor.class);
    }

    public void clear() {
        this.skipListenerCache.clear();
    }

    public boolean containsKey(final K key) {
        this.checkNotClosed();
        if (log.isTraceEnabled()) {
            log.tracef("Invoke containsKey(key=%s)", key);
        }
        if (key == null) {
            throw log.parameterMustNotBeNull("key");
        }
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.skipCacheLoadCache.containsKey(key);
                }
            });
        }
        return this.skipCacheLoadCache.containsKey(key);
    }

    public V get(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.doGet(key);
                }
            });
        }
        return this.doGet(key);
    }

    private V doGet(K key) {
        Object value = this.cache.get(key);
        if (value != null) {
            this.updateTTLForAccessed(this.cache, new JCacheEntry<K, Object>(key, value));
        }
        return (V)value;
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        if (keys.isEmpty()) {
            return InfinispanCollections.emptyMap();
        }
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            V value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public V getAndPut(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.put(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadAndStatsCache, key, value, false);
                }
            });
        }
        return this.put(this.skipCacheLoadCache, this.skipCacheLoadAndStatsCache, key, value, false);
    }

    public V getAndRemove(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.skipCacheLoadCache.remove(key);
                }
            });
        }
        return (V)this.skipCacheLoadCache.remove(key);
    }

    public V getAndReplace(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock().call(key, new Callable<V>(){

                @Override
                public V call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, value);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, value);
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void close() {
        this.cache.stop();
    }

    public boolean isClosed() {
        return this.cache.getStatus().isTerminated();
    }

    public Configuration<K, V> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.cache.getName();
    }

    public <T> T invoke(final K key, final Cache.EntryProcessor<K, V, T> entryProcessor, final Object ... arguments) {
        this.checkNotClosed();
        this.verifyKey(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry processor cannot be null");
        }
        if (log.isTraceEnabled()) {
            log.tracef("Invoke entry processor %s for key=%s", entryProcessor, key);
        }
        return (T)new WithProcessorLock().call(key, new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object oldValue;
                Object safeOldValue = oldValue = JCache.this.skipCacheLoadAndStatsCache.get(key);
                if (JCache.this.configuration.isStoreByValue()) {
                    safeOldValue = JCache.this.safeCopy(oldValue);
                }
                MutableJCacheEntry<Object, Object> mutable = new MutableJCacheEntry<Object, Object>(JCache.this.cache, key, safeOldValue);
                Object ret = entryProcessor.process(mutable, arguments);
                if (mutable.isRemoved()) {
                    JCache.this.cache.remove(key);
                } else {
                    Object newValue = mutable.getNewValue();
                    if (newValue != null) {
                        if (oldValue != null) {
                            JCache.this.cache.replace(key, oldValue, newValue);
                        } else {
                            JCache.this.cache.putIfAbsent(key, newValue);
                        }
                    }
                }
                return ret;
            }
        });
    }

    public <T> Map<K, T> invokeAll(Set<? extends K> keys, Cache.EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        return null;
    }

    private V safeCopy(V original) {
        try {
            StreamingMarshaller marshaller = this.skipCacheLoadCache.getComponentRegistry().getCacheMarshaller();
            byte[] bytes = marshaller.objectToByteBuffer(original);
            Object o = marshaller.objectFromByteBuffer(bytes);
            return (V)o;
        }
        catch (Exception e) {
            throw new CacheException("Unexpected error making a copy of entry " + original, (Throwable)e);
        }
    }

    private boolean lockRequired(K key) {
        boolean locked = this.processorLocks.isLocked(key);
        if (log.isTraceEnabled()) {
            log.tracef("Lock required for key=%s? %s", key, locked);
        }
        return locked;
    }

    private void acquiredProcessorLock(K key) throws InterruptedException {
        this.processorLocks.acquireLock((Object)Thread.currentThread(), key, this.lockTimeout, TimeUnit.MILLISECONDS);
    }

    private void releaseProcessorLock(K key) {
        this.processorLocks.releaseLock((Object)Thread.currentThread(), key);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        return new Itr();
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener listener) {
        this.checkNotClosed();
        if (keys == null) {
            throw log.parameterMustNotBeNull("keys");
        }
        if (this.cacheLoader == null) {
            return;
        }
        ArrayList<? extends K> keysToLoad = new ArrayList<K>(keys);
        for (K key : keys) {
            if (key != null) continue;
            throw log.parameterMustNotBeNull("Key");
        }
        try {
            Map loaded = this.cacheLoader.loadAll(keysToLoad);
            Iterator it = loaded.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != null) continue;
                it.remove();
            }
            this.cache.putAll(loaded);
            listener.onCompletion();
        }
        catch (Throwable t) {
            this.setListenerException(listener, t);
        }
    }

    private void setListenerException(CompletionListener listener, Throwable t) {
        if (t instanceof Exception) {
            listener.onException((Exception)t);
        } else {
            listener.onException((Exception)new CacheException(t));
        }
    }

    public void put(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                @Override
                public Void call() {
                    JCache.this.doPut(key, value);
                    return null;
                }
            });
        } else {
            this.doPut(key, value);
        }
    }

    public void putAll(Map<? extends K, ? extends V> inputMap) {
        this.checkNotClosed();
        if (inputMap == null || inputMap.containsKey(null) || inputMap.containsValue(null)) {
            throw new NullPointerException("inputMap is null or keys/values contain a null entry: " + inputMap);
        }
        for (final Map.Entry<K, V> e : inputMap.entrySet()) {
            final K key = e.getKey();
            if (this.lockRequired(key)) {
                new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.doPut(key, e.getValue());
                        return null;
                    }
                });
                continue;
            }
            this.doPut(key, e.getValue());
        }
    }

    private void doPut(K key, V value) {
        this.put(this.ignoreReturnValuesCache, this.skipCacheLoadAndStatsCache, key, value, false);
    }

    public boolean putIfAbsent(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.put(JCache.this.skipCacheLoadCache, JCache.this.skipCacheLoadCache, key, value, true) == null;
                }
            });
        }
        return this.put(this.skipCacheLoadCache, this.skipCacheLoadCache, key, value, true) == null;
    }

    public boolean remove(final K key) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.cache.remove(key) != null;
                }
            });
        }
        return this.cache.remove(key) != null;
    }

    public boolean remove(final K key, final V oldValue) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.cache.remove(key, oldValue);
                }
            });
        }
        return this.cache.remove(key, oldValue);
    }

    public void removeAll() {
        ArrayList<NotifyingFuture> futures = new ArrayList<NotifyingFuture>();
        Iterator<Object> i$ = this.iterator();
        while (i$.hasNext()) {
            Cache.Entry<K, V> entry = i$.next();
            final Object key = entry.getKey();
            if (this.lockRequired(key)) {
                new WithProcessorLock<Void>().call(key, new Callable<Void>(){

                    @Override
                    public Void call() {
                        JCache.this.cache.remove(key);
                        return null;
                    }
                });
                continue;
            }
            futures.add(this.cache.removeAsync(key));
        }
        for (Future future : futures) {
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new CacheException("Interrupted while waiting for remove to complete");
            }
            catch (Exception e) {
                throw new CacheException("Removing all entries from cache failed", (Throwable)e);
            }
        }
    }

    public void removeAll(Set<? extends K> keys) {
        this.checkNotClosed();
        this.verifyKeys(keys);
        for (K k : keys) {
            this.remove(k);
        }
    }

    public boolean replace(final K key, final V value) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, null, value, false);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, null, value, false);
    }

    public boolean replace(final K key, final V oldValue, final V newValue) {
        this.checkNotClosed();
        if (this.lockRequired(key)) {
            return new WithProcessorLock<Boolean>().call(key, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return JCache.this.replace(JCache.this.skipCacheLoadCache, key, oldValue, newValue, true);
                }
            });
        }
        return this.replace(this.skipCacheLoadCache, key, oldValue, newValue, true);
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)ReflectionUtil.unwrap((Object)this, clazz);
    }

    void setManagementEnabled(boolean enabled) {
        if (enabled) {
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.CONFIGURATION);
        }
    }

    void setStatisticsEnabled(boolean enabled) {
        if (enabled) {
            this.cache.getStats().setStatisticsEnabled(enabled);
            RIMBeanServerRegistrationUtility.registerCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
        } else {
            RIMBeanServerRegistrationUtility.unregisterCacheObject(this, RIMBeanServerRegistrationUtility.ObjectNameType.STATISTICS);
            this.cache.getStats().setStatisticsEnabled(enabled);
        }
    }

    CacheMXBean getCacheMXBean() {
        return this.mxBean;
    }

    CacheStatisticsMXBean getCacheStatisticsMXBean() {
        return this.stats;
    }

    MBeanServer getMBeanServer() {
        return JmxUtil.lookupMBeanServer((GlobalConfiguration)this.cache.getCacheManager().getCacheManagerConfiguration());
    }

    private void checkNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("Cache is in " + this.cache.getStatus() + " state");
        }
    }

    private void verifyKeys(Set<? extends K> keys) {
        if (keys == null || keys.contains(null)) {
            throw new NullPointerException("keys is null or keys contains a null: " + keys);
        }
    }

    private void verifyKey(K key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
    }

    private void verifyNewValue(V newValue) {
        if (newValue == null) {
            throw new NullPointerException("New value cannot be null");
        }
    }

    private void verifyOldValue(V oldValue) {
        if (oldValue == null) {
            throw new NullPointerException("Old value cannot be null");
        }
    }

    private V put(AdvancedCache<K, V> cache, AdvancedCache<K, V> createCheckCache, K key, V value, boolean isPutIfAbsent) {
        Object ret;
        boolean isCreated = !createCheckCache.containsKey(key);
        JCacheEntry<K, V> entry = new JCacheEntry<K, V>(key, value);
        Duration ttl = isCreated ? this.expiryPolicy.getExpiryForCreatedEntry(entry) : this.expiryPolicy.getExpiryForModifiedEntry(entry);
        if (ttl == null || ttl.isEternal()) {
            ret = isPutIfAbsent ? cache.putIfAbsent(key, value) : cache.put(key, value);
        } else if (ttl.equals((Object)Duration.ZERO)) {
            ret = !isCreated ? cache.remove(key) : null;
        } else {
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            ret = isPutIfAbsent ? cache.putIfAbsent(key, value, duration, timeUnit) : cache.put(key, value, duration, timeUnit);
        }
        return (V)ret;
    }

    private boolean replace(AdvancedCache<K, V> cache, K key, V oldValue, V value, boolean isConditional) {
        boolean exists = cache.containsKey(key);
        if (exists) {
            JCacheEntry<K, V> entry = new JCacheEntry<K, V>(key, value);
            Duration ttl = this.expiryPolicy.getExpiryForModifiedEntry(entry);
            if (ttl == null || ttl.isEternal()) {
                return isConditional ? cache.replace(key, oldValue, value) : cache.replace(key, value) != null;
            }
            if (ttl.equals((Object)Duration.ZERO)) {
                return cache.remove(key) != null;
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return isConditional ? cache.replace(key, oldValue, value, duration, timeUnit) : cache.replace(key, value, duration, timeUnit) != null;
        }
        if (isConditional) {
            this.verifyOldValue(oldValue);
        }
        this.verifyNewValue(value);
        return false;
    }

    private V replace(AdvancedCache<K, V> cache, K key, V value) {
        boolean exists = cache.containsKey(key);
        if (exists) {
            JCacheEntry<K, V> entry = new JCacheEntry<K, V>(key, value);
            Duration ttl = this.expiryPolicy.getExpiryForModifiedEntry(entry);
            if (ttl == null || ttl.isEternal()) {
                return (V)cache.replace(key, value);
            }
            if (ttl.equals((Object)Duration.ZERO)) {
                return (V)cache.remove(key);
            }
            long duration = ttl.getDurationAmount();
            TimeUnit timeUnit = ttl.getTimeUnit();
            return (V)cache.replace(key, value, duration, timeUnit);
        }
        this.verifyNewValue(value);
        return null;
    }

    private void updateTTLForAccessed(AdvancedCache<K, V> cache, Cache.Entry<K, V> entry) {
        Duration ttl = this.expiryPolicy.getExpiryForAccessedEntry(entry);
        if (ttl != null) {
            if (ttl.equals((Object)Duration.ZERO)) {
                cache.remove(entry.getKey());
            } else {
                long durationAmount = ttl.getDurationAmount();
                TimeUnit timeUnit = ttl.getTimeUnit();
                cache.put(entry.getKey(), entry.getValue(), durationAmount, timeUnit);
            }
        }
    }

    private class Itr
    implements Iterator<Cache.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> it;
        private Cache.Entry<K, V> current;
        private Cache.Entry<K, V> next;

        Itr() {
            this.it = JCache.this.cache.entrySet().iterator();
            this.fetchNext();
        }

        private void fetchNext() {
            if (this.it.hasNext()) {
                Map.Entry entry = this.it.next();
                this.next = new JCacheEntry(entry.getKey(), entry.getValue());
            } else {
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (this.next == null) {
                this.fetchNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Cache.Entry ret = this.next;
            JCache.this.updateTTLForAccessed(JCache.this.cache, this.next);
            this.current = this.next;
            this.fetchNext();
            return ret;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            Object k = this.current.getKey();
            this.current = null;
            JCache.this.cache.remove(k);
        }
    }

    private class WithProcessorLock<V> {
        private WithProcessorLock() {
        }

        public V call(K key, Callable<V> callable) {
            try {
                JCache.this.acquiredProcessorLock(key);
                V v = callable.call();
                return v;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                V v = null;
                return v;
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
            finally {
                JCache.this.releaseProcessorLock(key);
            }
        }
    }
}

