/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolver;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Interceptor
@CacheRemoveAll
public class CacheRemoveAllInterceptor
implements Serializable {
    private static final long serialVersionUID = -8763819640664021763L;
    private static final Log log = (Log)LogFactory.getLog(CacheRemoveAllInterceptor.class, Log.class);
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    @Inject
    public CacheRemoveAllInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    @AroundInvoke
    public Object cacheRemoveAll(InvocationContext invocationContext) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("Interception of method named '%s'", invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheRemoveAll cacheRemoveAll = (CacheRemoveAll)cacheKeyInvocationContext.getCacheAnnotation();
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        if (!cacheRemoveAll.afterInvocation()) {
            cache.clear();
            if (log.isTraceEnabled()) {
                log.tracef("Clear cache '%s' before method invocation", cache.getName());
            }
        }
        Object result = invocationContext.proceed();
        if (cacheRemoveAll.afterInvocation()) {
            cache.clear();
            if (log.isTraceEnabled()) {
                log.tracef("Clear cache '%s' after method invocation", cache.getName());
            }
        }
        return result;
    }
}

