/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.configuration.Factory;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jcache.JCacheLoaderAdapterConfigurationBuilder;
import org.infinispan.jcache.JCacheWriterAdapterConfigurationBuilder;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.concurrent.IsolationLevel;

public class ConfigurationAdapter<K, V> {
    private javax.cache.configuration.Configuration<K, V> c;

    public ConfigurationAdapter(javax.cache.configuration.Configuration<K, V> configuration) {
        this.c = configuration;
    }

    public Configuration build() {
        Factory cacheWriterFactory;
        ConfigurationBuilder cb = new ConfigurationBuilder();
        if (this.c.isStoreByValue()) {
            cb.storeAsBinary().enable().defensive(true);
        }
        switch (this.c.getTransactionMode()) {
            case NONE: {
                cb.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
                break;
            }
            case LOCAL: {
                cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
                break;
            }
            case XA: {
                break;
            }
        }
        switch (this.c.getTransactionIsolationLevel()) {
            case NONE: {
                cb.locking().isolationLevel(IsolationLevel.NONE);
                break;
            }
            case READ_UNCOMMITTED: {
                cb.locking().isolationLevel(IsolationLevel.READ_UNCOMMITTED);
                break;
            }
            case READ_COMMITTED: {
                cb.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
                break;
            }
            case REPEATABLE_READ: {
                cb.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
                break;
            }
            case SERIALIZABLE: {
                cb.locking().isolationLevel(IsolationLevel.SERIALIZABLE);
                break;
            }
        }
        Factory cacheLoaderFactory = this.c.getCacheLoaderFactory();
        if (cacheLoaderFactory != null) {
            cb.loaders().addLoader(JCacheLoaderAdapterConfigurationBuilder.class);
        }
        if ((cacheWriterFactory = this.c.getCacheWriterFactory()) != null) {
            cb.loaders().addStore(JCacheWriterAdapterConfigurationBuilder.class);
        }
        if (this.c.isStatisticsEnabled()) {
            cb.jmxStatistics().enable();
        }
        return cb.build();
    }
}

