/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Interceptor
public class CacheResultInterceptor
implements Serializable {
    private static final long serialVersionUID = 5275055951121834315L;
    private static final Log log = (Log)LogFactory.getLog(CacheResultInterceptor.class, Log.class);
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    @Inject
    public CacheResultInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    @AroundInvoke
    public Object cacheResult(InvocationContext invocationContext) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("Interception of method named '%s'", invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        CacheResult cacheResult = (CacheResult)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        Object result = null;
        if (!cacheResult.skipGet()) {
            result = cache.get((Object)cacheKey);
            if (log.isTraceEnabled()) {
                log.tracef("Entry with value '%s' has been found in cache '%s' with key '%s'", result, cache.getName(), cacheKey);
            }
        }
        if (result == null && (result = invocationContext.proceed()) != null) {
            cache.put((Object)cacheKey, result);
            if (log.isTraceEnabled()) {
                log.tracef("Value '%s' cached in cache '%s' with key '%s'", result, cache.getName(), cacheKey);
            }
        }
        return result;
    }
}

