/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CacheRemoveEntry;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Interceptor
public class CacheRemoveEntryInterceptor
implements Serializable {
    private static final long serialVersionUID = -9079291622309963969L;
    private static final Log log = (Log)LogFactory.getLog(CacheRemoveEntryInterceptor.class, Log.class);
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    @Inject
    public CacheRemoveEntryInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    @AroundInvoke
    public Object cacheRemoveEntry(InvocationContext invocationContext) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("Interception of method named '%s'", invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheRemoveEntry cacheRemoveEntry = (CacheRemoveEntry)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        if (!cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
            if (log.isTraceEnabled()) {
                log.tracef("Remove entry with key '%s' in cache '%s' before method invocation", cacheKey, cache.getName());
            }
        }
        Object result = invocationContext.proceed();
        if (cacheRemoveEntry.afterInvocation()) {
            cache.remove((Object)cacheKey);
            if (log.isTraceEnabled()) {
                log.tracef("Remove entry with key '%s' in cache '%s' after method invocation", cacheKey, cache.getName());
            }
        }
        return result;
    }
}

