/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheStatisticsMXBean;
import org.infinispan.AdvancedCache;
import org.infinispan.stats.Stats;

public class RICacheStatistics
implements CacheStatisticsMXBean,
Serializable {
    private static final long serialVersionUID = -5589437411679003894L;
    private final AdvancedCache<?, ?> cache;
    private Date lastCollectionStartDate = new Date();

    public RICacheStatistics(AdvancedCache<?, ?> cache) {
        this.cache = cache;
    }

    public void clear() {
        this.cache.getStats().reset();
        this.lastCollectionStartDate = new Date();
    }

    public Date getStartAccumulationDate() {
        return this.lastCollectionStartDate;
    }

    public long getCacheHits() {
        return this.mapToSpecValidStat(this.cache.getStats().getHits());
    }

    public float getCacheHitPercentage() {
        long hits = this.getCacheHits();
        if (hits == 0L) {
            return 0.0f;
        }
        return hits / this.getCacheGets();
    }

    public long getCacheMisses() {
        return this.mapToSpecValidStat(this.cache.getStats().getMisses());
    }

    public float getCacheMissPercentage() {
        long misses = this.getCacheMisses();
        if (misses == 0L) {
            return 0.0f;
        }
        return misses / this.getCacheGets();
    }

    public long getCacheGets() {
        Stats stats = this.cache.getStats();
        return stats.getHits() + stats.getMisses();
    }

    public long getCachePuts() {
        return this.mapToSpecValidStat(this.cache.getStats().getStores());
    }

    public long getCacheRemovals() {
        Stats stats = this.cache.getStats();
        return this.mapToSpecValidStat(stats.getRemoveHits() + stats.getRemoveMisses());
    }

    public long getCacheEvictions() {
        return this.mapToSpecValidStat(this.cache.getStats().getEvictions());
    }

    public float getAverageGetTime() {
        return TimeUnit.MILLISECONDS.toMicros(this.mapToSpecValidStat(this.cache.getStats().getAverageReadTime()));
    }

    public float getAveragePutTime() {
        return TimeUnit.MILLISECONDS.toMicros(this.mapToSpecValidStat(this.cache.getStats().getAverageWriteTime()));
    }

    public float getAverageRemoveTime() {
        return TimeUnit.MILLISECONDS.toMicros(this.mapToSpecValidStat(this.cache.getStats().getAverageRemoveTime()));
    }

    private long mapToSpecValidStat(long stat) {
        return stat < 0L ? 0L : stat;
    }
}

