/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Configuration;
import javax.cache.MutableConfiguration;
import javax.cache.OptionalFeature;
import javax.cache.Status;
import javax.cache.spi.CachingProvider;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;
import javax.transaction.UserTransaction;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jcache.ConfigurationAdapter;
import org.infinispan.jcache.JCache;
import org.infinispan.jcache.JCacheUserTransaction;
import org.infinispan.jcache.logging.Log;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.LogFactory;

public class JCacheManager
implements CacheManager {
    private static final Log log = (Log)LogFactory.getLog(JCacheManager.class, Log.class);
    private final HashMap<String, JCache<?, ?>> caches = new HashMap();
    private final URI uri;
    private final EmbeddedCacheManager cm;
    private final CachingProvider provider;
    private volatile Status status = Status.UNINITIALISED;
    private final StackTraceElement[] allocationStackTrace = Thread.currentThread().getStackTrace();

    public JCacheManager(URI uri, ClassLoader classLoader, CachingProvider provider) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Classloader cannot be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Invalid CacheManager URI " + uri);
        }
        this.uri = uri;
        this.provider = provider;
        ConfigurationBuilderHolder cbh = this.getConfigurationBuilderHolder(classLoader);
        GlobalConfigurationBuilder globalBuilder = cbh.getGlobalConfigurationBuilder();
        String cacheManagerName = "uri=" + uri + "/classloader=" + classLoader.toString() + "/provider=" + provider.toString();
        globalBuilder.classLoader(classLoader).globalJmxStatistics().cacheManagerName(cacheManagerName);
        this.cm = new DefaultCacheManager(cbh, true);
        this.registerPredefinedCaches();
        this.status = Status.STARTED;
    }

    public JCacheManager(URI uri, EmbeddedCacheManager cacheManager, CachingProvider provider) {
        this.uri = uri;
        this.provider = provider;
        this.cm = cacheManager;
        this.registerPredefinedCaches();
        this.status = Status.STARTED;
    }

    private void registerPredefinedCaches() {
        Set cacheNames = this.cm.getCacheNames();
        for (String cacheName : cacheNames) {
            this.caches.put(cacheName, new JCache(this.cm.getCache(cacheName).getAdvancedCache(), this, new MutableConfiguration()));
        }
    }

    private ConfigurationBuilderHolder getConfigurationBuilderHolder(ClassLoader classLoader) {
        try {
            FileLookup fileLookup = FileLookupFactory.newInstance();
            InputStream configurationStream = this.uri.isAbsolute() ? fileLookup.lookupFileStrict(this.uri, classLoader) : fileLookup.lookupFileStrict(this.uri.toString(), classLoader);
            return new ParserRegistry(classLoader).parse(configurationStream);
        }
        catch (FileNotFoundException e) {
            return new ConfigurationBuilderHolder(classLoader);
        }
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.uri;
    }

    public Properties getProperties() {
        return null;
    }

    public Status getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> configureCache(String cacheName, Configuration<K, V> c) {
        boolean isolationWithNoTx;
        this.checkStartedStatus();
        if (cacheName == null || cacheName.length() == 0) {
            throw new NullPointerException("cacheName specified is invalid " + cacheName);
        }
        if (c == null) {
            throw new NullPointerException("configuration specified is invalid " + c);
        }
        boolean noIsolationWithTx = c.getTransactionIsolationLevel() == IsolationLevel.NONE && c.getTransactionMode() != Mode.NONE;
        boolean bl = isolationWithNoTx = c.getTransactionIsolationLevel() != IsolationLevel.NONE && c.getTransactionMode() == Mode.NONE;
        if (noIsolationWithTx || isolationWithNoTx) {
            throw new IllegalArgumentException("Incompatible IsolationLevel " + c.getTransactionIsolationLevel() + " and tx mode " + c.getTransactionMode());
        }
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            JCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache == null) {
                ConfigurationAdapter<K, V> adapter = new ConfigurationAdapter<K, V>(c);
                this.cm.defineConfiguration(cacheName, adapter.build());
                AdvancedCache ispnCache = this.cm.getCache(cacheName).getAdvancedCache();
                if (!ispnCache.getStatus().allowInvocations()) {
                    ispnCache.start();
                }
                cache = new JCache<K, V>(ispnCache, this, c);
                cache.start();
                this.caches.put(cache.getName(), cache);
            } else if (!cache.getConfiguration().equals(c)) {
                throw new CacheException("Cache " + cacheName + " already registered with configuration " + cache.getConfiguration() + ", and can not be registered again with a new given configuration " + c);
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> configureCache(String cacheName, AdvancedCache<K, V> ispnCache) {
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            JCache<Object, Object> cache = this.caches.get(cacheName);
            if (cache == null) {
                cache = new JCache<K, V>(ispnCache, this, new MutableConfiguration());
                this.caches.put(cacheName, cache);
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.checkStartedStatus();
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            return this.caches.get(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<Cache<?, ?>> getCaches() {
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            HashSet<Cache> set = new HashSet<Cache>();
            for (Cache cache : this.caches.values()) {
                set.add(cache);
            }
            return Collections.unmodifiableSet(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCache(String cacheName) {
        Cache oldCache;
        this.checkStartedStatus();
        if (cacheName == null) {
            throw new NullPointerException();
        }
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            oldCache = this.caches.remove(cacheName);
        }
        if (oldCache != null) {
            oldCache.stop();
        }
        return oldCache != null;
    }

    public UserTransaction getUserTransaction() {
        return new JCacheUserTransaction(this.cm.getCache().getAdvancedCache().getTransactionManager());
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return this.provider.isSupported(optionalFeature);
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.caches.get(cacheName).setManagementEnabled(enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.caches.get(cacheName).setStatisticsEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList cacheList;
        this.checkStartedStatus();
        HashMap<String, JCache<?, ?>> hashMap = this.caches;
        synchronized (hashMap) {
            cacheList = new ArrayList(this.caches.values());
            this.caches.clear();
        }
        for (Cache cache : cacheList) {
            try {
                cache.stop();
            }
            catch (Exception e) {}
        }
        this.cm.stop();
        this.status = Status.STOPPED;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwapping to " + cls + " is not a supported by this implementation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.status != Status.STOPPED) {
                Log.LeakDescription t = log.cacheManagerNotClosed();
                t.setStackTrace(this.allocationStackTrace);
                log.leakedCacheManager(t);
                this.cm.stop();
            }
        }
        finally {
            super.finalize();
        }
    }

    private void checkStartedStatus() {
        if (this.status != Status.STARTED) {
            throw new IllegalStateException();
        }
    }
}

