/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.CacheManagerFactory;
import javax.cache.CachingShutdownException;
import org.infinispan.jcache.JCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JCacheManagerFactory
implements CacheManagerFactory {
    private static final Log log = LogFactory.getLog(JCacheManagerFactory.class);
    private static final JCacheManagerFactory INSTANCE = new JCacheManagerFactory();
    private final Map<ClassLoader, Map<String, JCacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<String, JCacheManager>>();

    private JCacheManagerFactory() {
    }

    public CacheManager getCacheManager(String name) {
        return this.getCacheManager(Thread.currentThread().getContextClassLoader(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(ClassLoader classLoader, String name) {
        if (classLoader == null) {
            throw new NullPointerException("Invalid classloader specified " + classLoader);
        }
        if (name == null) {
            throw new NullPointerException("Invalid cache name specified " + name);
        }
        Map<ClassLoader, Map<String, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            JCacheManager cacheManager;
            Map<String, JCacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 == null) {
                if (log.isTraceEnabled()) {
                    log.tracef("No cache managers registered under '%s'", (Object)name);
                }
                map2 = new HashMap<String, JCacheManager>();
                this.cacheManagers.put(classLoader, map2);
            }
            if ((cacheManager = map2.get(name)) == null) {
                cacheManager = this.createCacheManager(classLoader, name);
                if (log.isTraceEnabled()) {
                    log.tracef("Created '%s' cache manager", (Object)name);
                }
                map2.put(name, cacheManager);
            }
            return cacheManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CachingShutdownException {
        Map<ClassLoader, Map<String, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            IdentityHashMap failures = new IdentityHashMap();
            for (Map<String, JCacheManager> map2 : this.cacheManagers.values()) {
                try {
                    this.shutdown(map2);
                }
                catch (CachingShutdownException e) {
                    failures.putAll(e.getFailures());
                }
            }
            this.cacheManagers.clear();
            if (log.isTraceEnabled()) {
                log.tracef("All cache managers have been removed", new Object[0]);
            }
            if (!failures.isEmpty()) {
                throw new CachingShutdownException(failures);
            }
        }
    }

    public boolean close(ClassLoader classLoader) throws CachingShutdownException {
        return this.close(classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(ClassLoader classLoader, String name) throws CachingShutdownException {
        Map<ClassLoader, Map<String, JCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            if (name != null) {
                Map<String, JCacheManager> map2 = this.cacheManagers.get(classLoader);
                JCacheManager cacheManager = map2.remove(name);
                if (map2.isEmpty()) {
                    this.cacheManagers.remove(classLoader);
                }
                if (cacheManager == null) {
                    return false;
                }
                cacheManager.shutdown();
                return true;
            }
            Map<String, JCacheManager> map3 = this.cacheManagers.remove(classLoader);
            if (map3 == null) {
                return false;
            }
            this.shutdown(map3);
            return true;
        }
    }

    public static JCacheManagerFactory getInstance() {
        return INSTANCE;
    }

    private void shutdown(Map<String, JCacheManager> map) throws CachingShutdownException {
        IdentityHashMap<JCacheManager, Exception> failures = new IdentityHashMap<JCacheManager, Exception>();
        for (JCacheManager cacheManager : map.values()) {
            try {
                cacheManager.shutdown();
                if (!log.isTraceEnabled()) continue;
                log.tracef("Shutdown cache manager '%s'", (Object)cacheManager.getName());
            }
            catch (Exception e) {
                failures.put(cacheManager, e);
            }
        }
        if (!failures.isEmpty()) {
            throw new CachingShutdownException(failures);
        }
    }

    private JCacheManager createCacheManager(ClassLoader classLoader, String name) {
        return new JCacheManager(name, classLoader);
    }
}

