/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.interceptor.InvocationContext;
import org.infinispan.commons.util.Util;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractCacheResultInterceptor
implements Serializable {
    private static final long serialVersionUID = 5275055951121834315L;
    private final CacheResolver defaultCacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    public AbstractCacheResultInterceptor(CacheResolver defaultCacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.defaultCacheResolver = defaultCacheResolver;
        this.contextFactory = contextFactory;
    }

    public Object cacheResult(InvocationContext invocationContext) throws Throwable {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().tracef("Interception of method '%s.%s'", (Object)invocationContext.getMethod().getDeclaringClass().getName(), (Object)invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContextImpl cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = cacheKeyInvocationContext.getCacheKeyGenerator();
        CacheResult cacheResult = (CacheResult)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        CacheResolver cacheResolver = cacheKeyInvocationContext.getCacheResolver();
        if (cacheResolver == null) {
            cacheResolver = this.defaultCacheResolver;
        }
        Cache cache = cacheResolver.resolveCache(cacheKeyInvocationContext);
        CacheResolver exceptionCacheResolver = cacheKeyInvocationContext.getExceptionCacheResolver();
        Cache exceptionCache = exceptionCacheResolver != null ? cacheResolver.resolveCache(cacheKeyInvocationContext) : null;
        Object result = null;
        if (!cacheResult.skipGet()) {
            Throwable throwable;
            result = cache.get((Object)cacheKey);
            if (this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Found in cache '%s' key '%s' with value '%s'", (Object)cache.getName(), (Object)cacheKey, (Object)Util.toStr((Object)result));
            }
            if (exceptionCache != null && (throwable = (Throwable)exceptionCache.get((Object)cacheKey)) != null) {
                throw throwable;
            }
        }
        if (result == null) {
            try {
                result = invocationContext.proceed();
                if (result != null) {
                    cache.put((Object)cacheKey, result);
                    if (this.getLog().isTraceEnabled()) {
                        this.getLog().tracef("Cached return value in cache '%s' with key '%s': '%s'", (Object)cache.getName(), (Object)cacheKey, (Object)Util.toStr((Object)result));
                    }
                }
            }
            catch (Throwable t) {
                this.cacheException(cacheResult, cacheKey, (Cache<GeneratedCacheKey, Throwable>)exceptionCache, t);
                throw t;
            }
        }
        return result;
    }

    private void cacheException(CacheResult cacheResult, GeneratedCacheKey cacheKey, Cache<GeneratedCacheKey, Throwable> exceptionCache, Throwable t) {
        if (exceptionCache != null) {
            boolean shouldCache = cacheResult.cachedExceptions().length == 0;
            for (Class includedException : cacheResult.cachedExceptions()) {
                if (!includedException.isAssignableFrom(t.getClass())) continue;
                shouldCache = true;
            }
            for (Class excludedException : cacheResult.nonCachedExceptions()) {
                if (!excludedException.isAssignableFrom(t.getClass())) continue;
                shouldCache = false;
            }
            if (shouldCache) {
                exceptionCache.put((Object)cacheKey, (Object)t);
            }
        }
    }

    protected abstract Log getLog();
}

