/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.embedded;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.cache.configuration.Factory;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public class LimitExpiryFactory
implements Factory<ExpiryPolicy>,
Serializable {
    private final Factory<ExpiryPolicy> factory;
    private final long lifespan;
    private final long maxIdle;

    public LimitExpiryFactory(Factory<ExpiryPolicy> factory, long lifespan, long maxIdle) {
        this.factory = factory;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
    }

    public ExpiryPolicy create() {
        return new LimitExpiryPolicy((ExpiryPolicy)this.factory.create(), this.lifespan, this.maxIdle);
    }

    private static class LimitExpiryPolicy
    implements ExpiryPolicy {
        private final ExpiryPolicy expiryPolicy;
        private final long maxIdle;
        private final long min;

        public LimitExpiryPolicy(ExpiryPolicy expiryPolicy, long lifespan, long maxIdle) {
            this.expiryPolicy = expiryPolicy;
            this.maxIdle = maxIdle;
            long l = maxIdle >= 0L ? (lifespan >= 0L ? Math.min(maxIdle, lifespan) : maxIdle) : (this.min = lifespan);
            assert (this.min >= 0L);
        }

        public Duration getExpiryForCreation() {
            Duration duration = this.expiryPolicy.getExpiryForCreation();
            if (duration == null) {
                return null;
            }
            if (duration.isZero()) {
                return duration;
            }
            if (duration.isEternal()) {
                return new Duration(TimeUnit.MILLISECONDS, this.min);
            }
            long actualMin = Math.min(duration.getTimeUnit().toMillis(duration.getDurationAmount()), this.min);
            return new Duration(TimeUnit.MILLISECONDS, actualMin);
        }

        public Duration getExpiryForAccess() {
            Duration duration = this.expiryPolicy.getExpiryForAccess();
            if (duration == null) {
                return null;
            }
            if (duration.isZero() || this.maxIdle < 0L) {
                return duration;
            }
            if (duration.isEternal()) {
                return new Duration(TimeUnit.MILLISECONDS, this.maxIdle);
            }
            long actualMin = Math.min(duration.getTimeUnit().toMillis(duration.getDurationAmount()), this.maxIdle);
            return new Duration(TimeUnit.MILLISECONDS, actualMin);
        }

        public Duration getExpiryForUpdate() {
            Duration duration = this.expiryPolicy.getExpiryForUpdate();
            if (duration == null) {
                return null;
            }
            if (duration.isZero()) {
                return duration;
            }
            if (duration.isEternal()) {
                return new Duration(TimeUnit.MILLISECONDS, this.min);
            }
            long actualMin = Math.min(duration.getTimeUnit().toMillis(duration.getDurationAmount()), this.min);
            return new Duration(TimeUnit.MILLISECONDS, actualMin);
        }
    }
}

