/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.VersionedOperationResponse;
import org.infinispan.hotrod.impl.operations.AbstractKeyValueOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class ReplaceIfUnmodifiedOperation<K, V>
extends AbstractKeyValueOperation<K, VersionedOperationResponse<CacheEntry<K, V>>> {
    private final long version;

    public ReplaceIfUnmodifiedOperation(OperationContext operationContext, K key, byte[] keyBytes, byte[] value, long version, CacheWriteOptions options, DataFormat dataFormat) {
        super(operationContext, (short)9, (short)10, key, keyBytes, value, (CacheOptions)options, dataFormat);
        this.version = version;
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        Codec codec = this.operationContext.getCodec();
        CacheEntryExpiration.Impl expiration = (CacheEntryExpiration.Impl)((CacheWriteOptions)this.options).expiration();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + ByteBufUtil.estimateArraySize(this.keyBytes) + codec.estimateExpirationSize(expiration) + 8 + ByteBufUtil.estimateArraySize(this.value));
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        codec.writeExpirationParams(buf, expiration);
        buf.writeLong(this.version);
        ByteBufUtil.writeArray(buf, this.value);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isSuccess(status)) {
            this.statsDataStore();
        }
        this.complete(this.returnVersionedOperationResponse(buf, status));
    }
}

