/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.hibernate.cache.commons.InfinispanBaseRegion;
import org.infinispan.hibernate.cache.commons.util.BeginInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EvictAllCommand;
import org.infinispan.util.ByteString;

public class CacheCommandFactory
implements ModuleCommandFactory {
    private ConcurrentMap<String, InfinispanBaseRegion> allRegions = new ConcurrentHashMap<String, InfinispanBaseRegion>();

    public void addRegion(InfinispanBaseRegion region) {
        this.allRegions.put(region.getName(), region);
    }

    public void clearRegions(Collection<? extends InfinispanBaseRegion> regions) {
        regions.forEach(region -> {
            InfinispanBaseRegion cfr_ignored_0 = (InfinispanBaseRegion)this.allRegions.remove(region.getName());
        });
    }

    public Map<Byte, Class<? extends ReplicableCommand>> getModuleCommands() {
        HashMap<Byte, Class<? extends ReplicableCommand>> map = new HashMap<Byte, Class<? extends ReplicableCommand>>(3);
        map.put((byte)120, EvictAllCommand.class);
        map.put((byte)121, EndInvalidationCommand.class);
        map.put((byte)122, BeginInvalidationCommand.class);
        return map;
    }

    public CacheRpcCommand fromStream(byte commandId, ByteString cacheName) {
        BaseRpcCommand c;
        switch (commandId) {
            case 120: {
                c = new EvictAllCommand(cacheName, (InfinispanBaseRegion)this.allRegions.get(cacheName.toString()));
                break;
            }
            case 121: {
                c = new EndInvalidationCommand(cacheName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not registered to handle command id " + commandId);
            }
        }
        return c;
    }

    public ReplicableCommand fromStream(byte commandId) {
        BeginInvalidationCommand c;
        switch (commandId) {
            case 122: {
                c = new BeginInvalidationCommand();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not registered to handle command id " + commandId);
            }
        }
        return c;
    }
}

