/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.context.Flag;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.impl.BaseRpcInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.ByteString;

public abstract class BaseInvalidationInterceptor
extends BaseRpcInterceptor
implements JmxStatisticsExposer {
    private final AtomicLong invalidations = new AtomicLong(0L);
    @Inject
    protected CommandsFactory commandsFactory;
    @Inject
    protected StateTransferManager stateTransferManager;
    @Inject
    protected Cache cache;
    protected ByteString cacheName;
    protected boolean statisticsEnabled;
    protected RpcOptions syncRpcOptions;
    protected RpcOptions asyncRpcOptions;

    @Start
    private void start() {
        this.cacheName = ByteString.fromString((String)this.cache.getName());
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
        this.syncRpcOptions = this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, DeliverOrder.NONE).build();
        this.asyncRpcOptions = this.rpcManager.getDefaultRpcOptions(false);
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @ManagedAttribute(displayName="Statistics enabled", description="Enables or disables the gathering of statistics by this component", dataType=DataType.TRAIT, writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations", displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }

    protected void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    protected List<Address> getMembers() {
        return this.stateTransferManager.getCacheTopology().getMembers();
    }

    protected boolean isPutForExternalRead(FlagAffectedCommand command) {
        return command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ);
    }
}

