/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.FutureUpdateSynchronization;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.impl.BaseTransactionalDataRegion;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.FutureUpdate;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.Tombstone;
import org.infinispan.hibernate.cache.commons.util.TombstoneUpdate;

public class TombstoneAccessDelegate
implements AccessDelegate {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(TombstoneAccessDelegate.class);
    private static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    protected final BaseTransactionalDataRegion region;
    protected final AdvancedCache cache;
    protected final AdvancedCache writeCache;
    protected final AdvancedCache asyncWriteCache;
    protected final AdvancedCache putFromLoadCache;
    protected final boolean requiresTransaction;

    public TombstoneAccessDelegate(BaseTransactionalDataRegion region) {
        this.region = region;
        this.cache = region.getCache();
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
        this.asyncWriteCache = this.writeCache.withFlags(new Flag[]{Flag.FORCE_ASYNCHRONOUS});
        this.putFromLoadCache = this.asyncWriteCache.withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY});
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.clustering().cacheMode().isInvalidation()) {
            throw new IllegalArgumentException("For tombstone-based caching, invalidation cache is not allowed.");
        }
        if (configuration.transaction().transactionMode().isTransactional()) {
            throw new IllegalArgumentException("Currently transactional caches are not supported.");
        }
        this.requiresTransaction = configuration.transaction().transactionMode().isTransactional() && !configuration.transaction().autoCommit();
    }

    @Override
    public Object get(Object session, Object key, long txTimestamp) throws CacheException {
        if (txTimestamp < this.region.getLastRegionInvalidation()) {
            return null;
        }
        Object value = this.cache.get(key);
        if (value instanceof Tombstone) {
            return null;
        }
        if (value instanceof FutureUpdate) {
            return ((FutureUpdate)value).getValue();
        }
        return value;
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        long lastRegionInvalidation = this.region.getLastRegionInvalidation();
        if (txTimestamp < lastRegionInvalidation) {
            log.tracef("putFromLoad not executed since tx started at %d, before last region invalidation finished = %d", txTimestamp, lastRegionInvalidation);
            return false;
        }
        if (minimalPutOverride) {
            Object prev = this.cache.get(key);
            if (prev instanceof Tombstone) {
                Tombstone tombstone = (Tombstone)prev;
                long lastTimestamp = tombstone.getLastTimestamp();
                if (txTimestamp <= lastTimestamp) {
                    log.tracef("putFromLoad not executed since tx started at %d, before last invalidation finished = %d", txTimestamp, lastTimestamp);
                    return false;
                }
            } else if (prev != null) {
                log.tracef("putFromLoad not executed since cache contains %s", prev);
                return false;
            }
        }
        this.putFromLoadCache.put(key, new TombstoneUpdate<Object>(SESSION_ACCESS.getTimestamp(session), value));
        return true;
    }

    @Override
    public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
        this.write(session, key, value);
        return true;
    }

    @Override
    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.write(session, key, value);
        return true;
    }

    @Override
    public void remove(Object session, Object key) throws CacheException {
        this.write(session, key, null);
    }

    protected void write(Object session, Object key, Object value) {
        SessionAccess.TransactionCoordinatorAccess tc = SESSION_ACCESS.getTransactionCoordinator(session);
        long timestamp = SESSION_ACCESS.getTimestamp(session);
        FutureUpdateSynchronization sync = new FutureUpdateSynchronization(tc, this.asyncWriteCache, this.requiresTransaction, key, value, this.region, timestamp);
        Tombstone tombstone = new Tombstone(sync.getUuid(), this.region.nextTimestamp() + this.region.getTombstoneExpiration());
        this.writeCache.put(key, (Object)tombstone);
        tc.registerLocalSynchronization(sync);
    }

    @Override
    public void removeAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.writeCache.put(key, new TombstoneUpdate<Object>(this.region.nextTimestamp(), null));
    }

    @Override
    public void evictAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void unlockItem(Object session, Object key) throws CacheException {
    }

    @Override
    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }
}

