/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.query;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.hibernate.cache.commons.InfinispanRegionFactory;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.impl.BaseTransactionalDataRegion;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.InvocationAfterCompletion;
import org.infinispan.transaction.TransactionMode;

public abstract class QueryResultsRegionImpl
extends BaseTransactionalDataRegion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(QueryResultsRegionImpl.class);
    private static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    private final AdvancedCache evictCache;
    private final AdvancedCache putCache;
    private final AdvancedCache getCache;
    private final ConcurrentMap<Object, Map> transactionContext = new ConcurrentHashMap<Object, Map>();
    private final boolean putCacheRequiresTransaction;

    public QueryResultsRegionImpl(AdvancedCache cache, String name, TransactionManager transactionManager, InfinispanRegionFactory factory) {
        super(cache, name, transactionManager, null, factory, null);
        boolean localOnly = Caches.isInvalidationCache(cache);
        this.evictCache = localOnly ? Caches.localCache(cache) : cache;
        this.putCache = localOnly ? Caches.failSilentWriteCache(cache, Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache(cache);
        this.getCache = Caches.failSilentReadCache(cache);
        TransactionConfiguration transactionConfiguration = this.putCache.getCacheConfiguration().transaction();
        boolean transactional = transactionConfiguration.transactionMode() != TransactionMode.NON_TRANSACTIONAL;
        boolean bl = this.putCacheRequiresTransaction = transactional && !transactionConfiguration.autoCommit();
        if (transactional) {
            log.useNonTransactionalQueryCache();
        }
    }

    @Override
    protected boolean isRegionAccessStrategyEnabled() {
        return false;
    }

    public void evict(Object key) throws CacheException {
        for (Map map : this.transactionContext.values()) {
            map.remove(key);
        }
        this.evictCache.remove(key);
    }

    public void evictAll() throws CacheException {
        this.transactionContext.clear();
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object getItem(Object session, Object key) throws CacheException {
        if (!this.checkValid()) {
            return null;
        }
        Object result = null;
        Map map = (Map)this.transactionContext.get(session);
        if (map != null) {
            result = map.get(key);
        }
        if (result == null) {
            result = this.getCache.get(key);
        }
        return result;
    }

    public void putItem(Object session, Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            SessionAccess.TransactionCoordinatorAccess tc = SESSION_ACCESS.getTransactionCoordinator(session);
            if (tc != null && tc.isJoined()) {
                tc.registerLocalSynchronization(new PostTransactionQueryUpdate(tc, session, key, value));
                HashMap<Object, Object> map = (HashMap<Object, Object>)this.transactionContext.get(session);
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    this.transactionContext.put(session, map);
                }
                map.put(key, value);
                return;
            }
            this.putCache.put(key, value);
        }
    }

    private class PostTransactionQueryUpdate
    extends InvocationAfterCompletion {
        private final Object session;
        private final Object key;
        private final Object value;

        public PostTransactionQueryUpdate(SessionAccess.TransactionCoordinatorAccess tc, Object session, Object key, Object value) {
            super(tc, QueryResultsRegionImpl.this.putCacheRequiresTransaction);
            this.session = session;
            this.key = key;
            this.value = value;
        }

        @Override
        public void afterCompletion(int status) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.session);
            super.afterCompletion(status);
        }

        @Override
        protected void invoke(boolean success) {
            if (success) {
                QueryResultsRegionImpl.this.putCache.put(this.key, this.value);
            }
        }
    }
}

