/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LockingInterceptor
extends NonTransactionalLockingInterceptor {
    private static final Log log = LogFactory.getLog(LockingInterceptor.class);
    protected final InvocationFinallyFunction unlockAllReturnCheckCompletableFutureHandler = (rCtx, rCommand, rv, throwable) -> {
        this.lockManager.unlockAll(rCtx);
        if (throwable != null) {
            throw throwable;
        }
        if (rv instanceof CompletableFuture) {
            return LockingInterceptor.asyncValue((CompletionStage)((CompletableFuture)rv));
        }
        return rv;
    };

    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        try {
            if (log.isTraceEnabled()) {
                Ownership ownership = this.cdl.getCacheTopology().getDistribution(command.getKey()).writeOwnership();
                log.tracef("Am I owner for key=%s ? %s", command.getKey(), (Object)ownership);
            }
            if (ctx.getLockOwner() == null) {
                ctx.setLockOwner((Object)command.getCommandInvocationId());
            }
            this.lockAndRecord(ctx, command.getKey(), this.getLockTimeoutMillis((FlagAffectedCommand)command));
        }
        catch (Throwable t) {
            this.lockManager.unlockAll(ctx);
            throw t;
        }
        return this.invokeNextAndHandle(ctx, (VisitableCommand)command, this.unlockAllReturnCheckCompletableFutureHandler);
    }
}

