package org.infinispan.hibernate.cache.commons.util;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.hibernate.cache.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.util.ByteString;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import javax.transaction.SystemException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import javax.naming.NamingException;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-07-19T14:02:36-0400")
public class InfinispanMessageLogger_$logger extends DelegatingBasicLogger implements InfinispanMessageLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = InfinispanMessageLogger_$logger.class.getName();
    public InfinispanMessageLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String pendingPutsMustNotBeClustered = "HHH025001: Pending-puts cache must not be clustered!";
    protected String pendingPutsMustNotBeClustered$str() {
        return pendingPutsMustNotBeClustered;
    }
    @Override
    public final CacheException pendingPutsMustNotBeClustered() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), pendingPutsMustNotBeClustered$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String pendingPutsMustNotBeTransactional = "HHH025002: Pending-puts cache must not be transactional!";
    protected String pendingPutsMustNotBeTransactional$str() {
        return pendingPutsMustNotBeTransactional;
    }
    @Override
    public final CacheException pendingPutsMustNotBeTransactional() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), pendingPutsMustNotBeTransactional$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void pendingPutsShouldBeTemplate() {
        super.log.logf(FQCN, WARN, null, pendingPutsShouldBeTemplate$str());
    }
    private static final String pendingPutsShouldBeTemplate = "HHH025003: Pending-puts cache configuration should be a template.";
    protected String pendingPutsShouldBeTemplate$str() {
        return pendingPutsShouldBeTemplate;
    }
    private static final String pendingPutsMustHaveMaxIdle = "HHH025004: Pending-puts cache must have expiration.max-idle set";
    protected String pendingPutsMustHaveMaxIdle$str() {
        return pendingPutsMustHaveMaxIdle;
    }
    @Override
    public final CacheException pendingPutsMustHaveMaxIdle() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), pendingPutsMustHaveMaxIdle$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void propertyUseSynchronizationDeprecated() {
        super.log.logf(FQCN, WARN, null, propertyUseSynchronizationDeprecated$str());
    }
    private static final String propertyUseSynchronizationDeprecated = "HHH025005: Property 'hibernate.cache.infinispan.use_synchronization' is deprecated; 2LC with transactional cache must always use synchronizations.";
    protected String propertyUseSynchronizationDeprecated$str() {
        return propertyUseSynchronizationDeprecated;
    }
    @Override
    public final void customConfigForTypeNotFound(final String cacheName, final String type) {
        super.log.logf(FQCN, ERROR, null, customConfigForTypeNotFound$str(), cacheName, type);
    }
    private static final String customConfigForTypeNotFound = "HHH025006: Custom cache configuration '%s' was requested for type %s but it was not found!";
    protected String customConfigForTypeNotFound$str() {
        return customConfigForTypeNotFound;
    }
    @Override
    public final void customConfigForRegionNotFound(final String templateCacheName, final String regionName, final String type) {
        super.log.logf(FQCN, ERROR, null, customConfigForRegionNotFound$str(), templateCacheName, regionName, type);
    }
    private static final String customConfigForRegionNotFound = "HHH025007: Custom cache configuration '%s' was requested for region %s but it was not found - using configuration by type (%s).";
    protected String customConfigForRegionNotFound$str() {
        return customConfigForRegionNotFound;
    }
    private static final String timestampsMustNotUseEviction = "HHH025008: Timestamps cache must not use eviction!";
    protected String timestampsMustNotUseEviction$str() {
        return timestampsMustNotUseEviction;
    }
    @Override
    public final CacheException timestampsMustNotUseEviction() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), timestampsMustNotUseEviction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToStart = "HHH025009: Unable to start region factory";
    protected String unableToStart$str() {
        return unableToStart;
    }
    @Override
    public final CacheException unableToStart(final Throwable t) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToStart$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateCacheManager = "HHH025010: Unable to create default cache manager";
    protected String unableToCreateCacheManager$str() {
        return unableToCreateCacheManager;
    }
    @Override
    public final CacheException unableToCreateCacheManager(final Throwable t) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToCreateCacheManager$str()), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstallCommandFactory = "HHH025011: Infinispan custom cache command factory not installed (possibly because the classloader where Infinispan lives couldn't find the Hibernate Infinispan cache provider)";
    protected String cannotInstallCommandFactory$str() {
        return cannotInstallCommandFactory;
    }
    @Override
    public final CacheException cannotInstallCommandFactory() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotInstallCommandFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void transactionalStrategyNonTransactionalCache() {
        super.log.logf(FQCN, WARN, null, transactionalStrategyNonTransactionalCache$str());
    }
    private static final String transactionalStrategyNonTransactionalCache = "HHH025012: Requesting TRANSACTIONAL cache concurrency strategy but the cache is not configured as transactional.";
    protected String transactionalStrategyNonTransactionalCache$str() {
        return transactionalStrategyNonTransactionalCache;
    }
    @Override
    public final void readWriteStrategyTransactionalCache() {
        super.log.logf(FQCN, WARN, null, readWriteStrategyTransactionalCache$str());
    }
    private static final String readWriteStrategyTransactionalCache = "HHH025013: Requesting READ_WRITE cache concurrency strategy but the cache was configured as transactional.";
    protected String readWriteStrategyTransactionalCache$str() {
        return readWriteStrategyTransactionalCache;
    }
    @Override
    public final void evictionWithTombstones() {
        super.log.logf(FQCN, WARN, null, evictionWithTombstones$str());
    }
    private static final String evictionWithTombstones = "HHH025014: Setting eviction on cache using tombstones can introduce inconsistencies!";
    protected String evictionWithTombstones$str() {
        return evictionWithTombstones;
    }
    @Override
    public final void failureInAfterCompletion(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failureInAfterCompletion$str());
    }
    private static final String failureInAfterCompletion = "HHH025015: Failure updating cache in afterCompletion, will retry";
    protected String failureInAfterCompletion$str() {
        return failureInAfterCompletion;
    }
    @Override
    public final void failedEndInvalidating(final Object key, final ByteString name) {
        super.log.logf(FQCN, ERROR, null, failedEndInvalidating$str(), key, name);
    }
    private static final String failedEndInvalidating = "HHH025016: Failed to end invalidating pending putFromLoad calls for key %s from region %s; the key won't be cached until invalidation expires.";
    protected String failedEndInvalidating$str() {
        return failedEndInvalidating;
    }
    private static final String unableToRetrieveCmFromJndi = "HHH025017: Unable to retrieve CacheManager from JNDI [%s]";
    protected String unableToRetrieveCmFromJndi$str() {
        return unableToRetrieveCmFromJndi;
    }
    @Override
    public final CacheException unableToRetrieveCmFromJndi(final String jndiNamespace) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), unableToRetrieveCmFromJndi$str(), jndiNamespace));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToReleaseContext(final NamingException ne) {
        super.log.logf(FQCN, WARN, ne, unableToReleaseContext$str());
    }
    private static final String unableToReleaseContext = "HHH025018: Unable to release initial context";
    protected String unableToReleaseContext$str() {
        return unableToReleaseContext;
    }
    @Override
    public final void useNonTransactionalQueryCache() {
        super.log.logf(FQCN, WARN, null, useNonTransactionalQueryCache$str());
    }
    private static final String useNonTransactionalQueryCache = "HHH025019: Use non-transactional query caches for best performance!";
    protected String useNonTransactionalQueryCache$str() {
        return useNonTransactionalQueryCache;
    }
    @Override
    public final void unableToRollbackInvalidationsDuringPrepare(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToRollbackInvalidationsDuringPrepare$str());
    }
    private static final String unableToRollbackInvalidationsDuringPrepare = "HHH025020: Unable to broadcast invalidations as a part of the prepare phase. Rolling back.";
    protected String unableToRollbackInvalidationsDuringPrepare$str() {
        return unableToRollbackInvalidationsDuringPrepare;
    }
    private static final String cannotSuspendTx = "HHH025021: Could not suspend transaction";
    protected String cannotSuspendTx$str() {
        return cannotSuspendTx;
    }
    @Override
    public final CacheException cannotSuspendTx(final SystemException se) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotSuspendTx$str()), se);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotResumeTx = "HHH025022: Could not resume transaction";
    protected String cannotResumeTx$str() {
        return cannotResumeTx;
    }
    @Override
    public final CacheException cannotResumeTx(final Exception e) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotResumeTx$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGetCurrentTx = "HHH025023: Unable to get current transaction";
    protected String cannotGetCurrentTx$str() {
        return cannotGetCurrentTx;
    }
    @Override
    public final CacheException cannotGetCurrentTx(final SystemException e) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), cannotGetCurrentTx$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedInvalidatePendingPut = "HHH025024: Failed to invalidate pending putFromLoad calls for key %s from region %s";
    protected String failedInvalidatePendingPut$str() {
        return failedInvalidatePendingPut;
    }
    @Override
    public final CacheException failedInvalidatePendingPut(final Object key, final String regionName) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), failedInvalidatePendingPut$str(), key, regionName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedInvalidateRegion(final String regionName) {
        super.log.logf(FQCN, ERROR, null, failedInvalidateRegion$str(), regionName);
    }
    private static final String failedInvalidateRegion = "HHH025025: Failed to invalidate pending putFromLoad calls for region %s";
    protected String failedInvalidateRegion$str() {
        return failedInvalidateRegion;
    }
    private static final String propertyCacheManagerResourceNotSet = "HHH025026: Property 'hibernate.cache.infinispan.cachemanager' not set";
    protected String propertyCacheManagerResourceNotSet$str() {
        return propertyCacheManagerResourceNotSet;
    }
    @Override
    public final CacheException propertyCacheManagerResourceNotSet() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), propertyCacheManagerResourceNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String timestampsMustNotUseInvalidation = "HHH025027: Timestamp cache cannot be configured with invalidation";
    protected String timestampsMustNotUseInvalidation$str() {
        return timestampsMustNotUseInvalidation;
    }
    @Override
    public final CacheException timestampsMustNotUseInvalidation() {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), timestampsMustNotUseInvalidation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void ignoringDeprecatedProperty(final String deprecated) {
        super.log.logf(FQCN, WARN, null, ignoringDeprecatedProperty$str(), deprecated);
    }
    private static final String ignoringDeprecatedProperty = "HHH025028: Ignoring deprecated property '%s'";
    protected String ignoringDeprecatedProperty$str() {
        return ignoringDeprecatedProperty;
    }
    @Override
    public final void deprecatedProperty(final String deprecated, final String alternative) {
        super.log.logf(FQCN, WARN, null, deprecatedProperty$str(), deprecated, alternative);
    }
    private static final String deprecatedProperty = "HHH025029: Property '%s' is deprecated, please use '%s' instead";
    protected String deprecatedProperty$str() {
        return deprecatedProperty;
    }
    @Override
    public final void transactionalConfigurationIgnored() {
        super.log.logf(FQCN, WARN, null, transactionalConfigurationIgnored$str());
    }
    private static final String transactionalConfigurationIgnored = "HHH025030: Transactional caches are not supported. The configuration option will be ignored; please unset.";
    protected String transactionalConfigurationIgnored$str() {
        return transactionalConfigurationIgnored;
    }
    @Override
    public final void pendingPutsCacheAlreadyDefined(final String pendingPutsName) {
        super.log.logf(FQCN, WARN, null, pendingPutsCacheAlreadyDefined$str(), pendingPutsName);
    }
    private static final String pendingPutsCacheAlreadyDefined = "HHH025031: Configuration for pending-puts cache '%s' is already defined - another instance of SessionFactory was not closed properly.";
    protected String pendingPutsCacheAlreadyDefined$str() {
        return pendingPutsCacheAlreadyDefined;
    }
    @Override
    public final void regionNameMatchesCacheName(final String regionName, final String regionName2, final String regionName3) {
        super.log.logf(FQCN, WARN, null, regionNameMatchesCacheName$str(), regionName, regionName2, regionName3);
    }
    private static final String regionNameMatchesCacheName = "HHH025032: Cache configuration '%s' is present but the use has not been defined through hibernate.cache.infinispan.%s.cfg=%s";
    protected String regionNameMatchesCacheName$str() {
        return regionNameMatchesCacheName;
    }
    @Override
    public final void usingUnqualifiedNameInConfiguration(final String unqualifiedRegionName, final String cacheName) {
        super.log.logf(FQCN, WARN, null, usingUnqualifiedNameInConfiguration$str(), unqualifiedRegionName, cacheName);
    }
    private static final String usingUnqualifiedNameInConfiguration = "HHH025033: Configuration properties contain record for unqualified region name '%s' but it should contain qualified region name '%s'";
    protected String usingUnqualifiedNameInConfiguration$str() {
        return usingUnqualifiedNameInConfiguration;
    }
    @Override
    public final void configurationWithUnqualifiedName(final String unqualifiedRegionName, final String cacheName) {
        super.log.logf(FQCN, WARN, null, configurationWithUnqualifiedName$str(), unqualifiedRegionName, cacheName);
    }
    private static final String configurationWithUnqualifiedName = "HHH025034: Configuration for unqualified region name '%s' is defined but the cache will use qualified name '%s'";
    protected String configurationWithUnqualifiedName$str() {
        return configurationWithUnqualifiedName;
    }
    @Override
    public final void failureBeforeTransactionCompletion(final int index, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failureBeforeTransactionCompletion$str(), index);
    }
    private static final String failureBeforeTransactionCompletion = "HHH025035: Operation #%d scheduled to complete before transaction completion failed";
    protected String failureBeforeTransactionCompletion$str() {
        return failureBeforeTransactionCompletion;
    }
    @Override
    public final void failureAfterTransactionCompletion(final int index, final boolean successful, final Exception e) {
        super.log.logf(FQCN, ERROR, e, failureAfterTransactionCompletion$str(), index, successful);
    }
    private static final String failureAfterTransactionCompletion = "HHH025036: Operation #%d scheduled after transaction completion failed (transaction successful? %s)";
    protected String failureAfterTransactionCompletion$str() {
        return failureAfterTransactionCompletion;
    }
}
