/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.functional.Param;
import org.infinispan.functional.impl.FunctionalMapImpl;
import org.infinispan.functional.impl.ReadWriteMapImpl;
import org.infinispan.hibernate.cache.commons.InfinispanDataRegion;
import org.infinispan.hibernate.cache.commons.access.AccessDelegate;
import org.infinispan.hibernate.cache.commons.access.RemovalSynchronization;
import org.infinispan.hibernate.cache.commons.access.SessionAccess;
import org.infinispan.hibernate.cache.commons.util.Caches;
import org.infinispan.hibernate.cache.commons.util.InfinispanMessageLogger;
import org.infinispan.hibernate.cache.commons.util.VersionedEntry;

public class NonStrictAccessDelegate
implements AccessDelegate {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(NonStrictAccessDelegate.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final SessionAccess SESSION_ACCESS = SessionAccess.findSessionAccess();
    protected final InfinispanDataRegion region;
    private final AdvancedCache cache;
    protected final FunctionalMap.ReadWriteMap<Object, Object> writeMap;
    private final FunctionalMap.ReadWriteMap<Object, Object> putFromLoadMap;
    private final Comparator versionComparator;

    public NonStrictAccessDelegate(InfinispanDataRegion region, Comparator versionComparator) {
        this.region = region;
        this.cache = region.getCache();
        FunctionalMapImpl fmap = FunctionalMapImpl.create((AdvancedCache)this.cache).withParams(new Param[]{Param.PersistenceMode.SKIP_LOAD});
        this.writeMap = ReadWriteMapImpl.create((FunctionalMapImpl)fmap);
        this.putFromLoadMap = ReadWriteMapImpl.create((FunctionalMapImpl)fmap).withParams(new Param[]{Param.LockingMode.TRY_LOCK, Param.ReplicationMode.ASYNC});
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.clustering().cacheMode().isInvalidation()) {
            throw new IllegalArgumentException("Nonstrict-read-write mode cannot use invalidation.");
        }
        if (configuration.transaction().transactionMode().isTransactional()) {
            throw new IllegalArgumentException("Currently transactional caches are not supported.");
        }
        this.versionComparator = versionComparator;
        if (versionComparator == null) {
            throw new IllegalArgumentException("This strategy requires versioned entities/collections but region " + region.getName() + " contains non-versioned data!");
        }
    }

    @Override
    public Object get(Object session, Object key, long txTimestamp) throws CacheException {
        if (txTimestamp < this.region.getLastRegionInvalidation()) {
            return null;
        }
        Object value = this.cache.get(key);
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getValue();
        }
        return value;
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    @Override
    public boolean putFromLoad(Object session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        Object prev;
        long lastRegionInvalidation = this.region.getLastRegionInvalidation();
        if (txTimestamp < lastRegionInvalidation) {
            log.tracef("putFromLoad not executed since tx started at %d, before last region invalidation finished = %d", txTimestamp, lastRegionInvalidation);
            return false;
        }
        assert (version != null);
        if (minimalPutOverride && (prev = this.cache.get(key)) != null) {
            Object oldVersion = this.getVersion(prev);
            if (oldVersion != null) {
                if (this.versionComparator.compare(version, oldVersion) <= 0) {
                    if (trace) {
                        log.tracef("putFromLoad not executed since version(%s) <= oldVersion(%s)", version, oldVersion);
                    }
                    return false;
                }
            } else if (prev instanceof VersionedEntry && txTimestamp <= ((VersionedEntry)prev).getTimestamp()) {
                if (trace) {
                    log.tracef("putFromLoad not executed since tx started at %d and entry was invalidated at %d", txTimestamp, ((VersionedEntry)prev).getTimestamp());
                }
                return false;
            }
        }
        CompletableFuture future = this.putFromLoadMap.eval(key, (Function)new VersionedEntry(value, version, txTimestamp));
        assert (future.isDone());
        future.join();
        return true;
    }

    @Override
    public boolean insert(Object session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public boolean update(Object session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    @Override
    public void remove(Object session, Object key) throws CacheException {
        SessionAccess.TransactionCoordinatorAccess transactionCoordinator = SESSION_ACCESS.getTransactionCoordinator(session);
        RemovalSynchronization sync = new RemovalSynchronization(transactionCoordinator, this.writeMap, this.region, key);
        transactionCoordinator.registerLocalSynchronization(sync);
    }

    @Override
    public void removeAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.writeMap.eval(key, (Function)new VersionedEntry(this.region.nextTimestamp())).join();
    }

    @Override
    public void evictAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void unlockItem(Object session, Object key) throws CacheException {
    }

    @Override
    public boolean afterInsert(Object session, Object key, Object value, Object version) {
        assert (value != null);
        assert (version != null);
        this.writeMap.eval(key, (Function)new VersionedEntry(value, version, SESSION_ACCESS.getTimestamp(session))).join();
        return true;
    }

    @Override
    public boolean afterUpdate(Object session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        assert (value != null);
        assert (currentVersion != null);
        this.writeMap.eval(key, (Function)new VersionedEntry(value, currentVersion, SESSION_ACCESS.getTimestamp(session))).join();
        return true;
    }

    protected Object getVersion(Object value) {
        if (value instanceof CacheEntry) {
            return ((CacheEntry)value).getVersion();
        }
        if (value instanceof VersionedEntry) {
            return ((VersionedEntry)value).getVersion();
        }
        return null;
    }
}

