/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.access;

import java.util.Collection;
import java.util.List;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class UnorderedDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static Log log = LogFactory.getLog(UnorderedDistributionInterceptor.class);
    @Inject
    private DistributionManager distributionManager;
    private boolean isReplicated;

    @Start
    public void start() {
        this.isReplicated = this.cacheConfiguration.clustering().cacheMode().isReplicated();
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) {
        return this.handleDataWriteCommand(ctx, (DataWriteCommand)command);
    }

    private Object handleDataWriteCommand(InvocationContext ctx, DataWriteCommand command) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL)) {
            return this.invokeNext(ctx, (VisitableCommand)command);
        }
        int commandTopologyId = command.getTopologyId();
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        int currentTopologyId = cacheTopology.getTopologyId();
        if (commandTopologyId != -1 && currentTopologyId != commandTopologyId) {
            throw OutdatedTopologyException.RETRY_NEXT_TOPOLOGY;
        }
        if (this.isReplicated) {
            return this.invokeNextAndHandle(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> this.invokeRemotelyAsync(null, rCtx, (WriteCommand)rCommand));
        }
        List owners = cacheTopology.getDistribution(command.getKey()).writeOwners();
        if (owners.contains(this.rpcManager.getAddress())) {
            return this.invokeNextAndHandle(ctx, (VisitableCommand)command, (rCtx, rCommand, rv, throwable) -> this.invokeRemotelyAsync(owners, rCtx, (WriteCommand)rCommand));
        }
        log.tracef("Not invoking %s on %s since it is not an owner", (Object)command, (Object)this.rpcManager.getAddress());
        if (ctx.isOriginLocal() && command.isSuccessful()) {
            if (this.isSynchronous((FlagAffectedCommand)command)) {
                return this.rpcManager.invokeCommand((Collection)owners, (ReplicableCommand)command, (ResponseCollector)MapResponseCollector.ignoreLeavers((int)owners.size()), this.rpcManager.getSyncRpcOptions());
            }
            this.rpcManager.sendToMany((Collection)owners, (ReplicableCommand)command, DeliverOrder.NONE);
        }
        return null;
    }

    public Object invokeRemotelyAsync(List<Address> finalOwners, InvocationContext rCtx, WriteCommand writeCmd) {
        if (rCtx.isOriginLocal() && writeCmd.isSuccessful()) {
            if (this.isSynchronous((FlagAffectedCommand)writeCmd)) {
                if (finalOwners != null) {
                    return this.rpcManager.invokeCommand(finalOwners, (ReplicableCommand)writeCmd, (ResponseCollector)MapResponseCollector.ignoreLeavers((int)finalOwners.size()), this.rpcManager.getSyncRpcOptions());
                }
                return this.rpcManager.invokeCommandOnAll((ReplicableCommand)writeCmd, (ResponseCollector)MapResponseCollector.ignoreLeavers(), this.rpcManager.getSyncRpcOptions());
            }
            this.rpcManager.sendToMany(finalOwners, (ReplicableCommand)writeCmd, DeliverOrder.NONE);
        }
        return null;
    }
}

