/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.infinispan.Cache;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachemanagerlistener.annotation.Merged;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.LegacyKeySupportSystemProperties;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanDemo {
    private static final Log log = LogFactory.getLog(InfinispanDemo.class);
    private static JFrame frame;
    private JTabbedPane mainPane;
    private JPanel panel1;
    private JLabel cacheStatus;
    private JPanel dataGeneratorTab;
    private JPanel clusterViewTab;
    private JPanel dataViewTab;
    private JPanel controlPanelTab;
    private JTable clusterTable;
    private JButton actionButton;
    private JLabel configFileName;
    private JProgressBar cacheStatusProgressBar;
    private JTextField keyTextField;
    private JTextField valueTextField;
    private JRadioButton putEntryRadioButton;
    private JRadioButton removeEntryRadioButton;
    private JRadioButton getEntryRadioButton;
    private JButton goButton;
    private JButton randomGeneratorButton;
    private JButton cacheClearButton;
    private JTextArea configFileContents;
    private String cacheConfigFile;
    private Cache<String, String> cache;
    private String startCacheButtonLabel = "Start Cache";
    private String stopCacheButtonLabel = "Stop Cache";
    private String statusStarting = "Starting Cache ... ";
    private String statusStarted = "Cache Running.";
    private String statusStopping = "Stopping Cache ...";
    private String statusStopped = "Cache Stopped.";
    private ExecutorService asyncExecutor;
    private ExecutorService tableUpdateExecutor;
    private JTable dataTable;
    private JSlider generateSlider;
    private JSpinner lifespanSpinner;
    private JSpinner maxIdleSpinner;
    private JButton refreshButton;
    private JPanel dataViewControlPanel;
    private JLabel cacheContentsSizeLabel;
    private Random r;
    private ClusterTableModel clusterTableModel;
    private CachedDataTableModel cachedDataTableModel;
    private DefaultCacheManager cacheManager;

    public static void main(String[] args) {
        String cfgFileName = null;
        cfgFileName = args.length > 0 ? args[0] : LegacyKeySupportSystemProperties.getProperty((String)"infinispan.configuration", (String)"infinispan.demo.cfg", (String)"config-samples/gui-demo-cache-config.xml");
        frame = new JFrame("Infinispan GUI Demo (STOPPED)");
        frame.setContentPane(new InfinispanDemo((String)cfgFileName).panel1);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
        frame.setResizable(true);
    }

    public InfinispanDemo(String cfgFileName) {
        this.$$$setupUI$$$();
        this.r = new Random();
        this.asyncExecutor = Executors.newFixedThreadPool(1);
        this.tableUpdateExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadPoolExecutor.DiscardPolicy());
        this.cacheConfigFile = cfgFileName;
        this.cacheStatusProgressBar.setVisible(false);
        this.cacheStatusProgressBar.setEnabled(false);
        this.configFileName.setText(this.cacheConfigFile);
        this.clusterTableModel = new ClusterTableModel();
        this.clusterTable.setModel(this.clusterTableModel);
        this.cachedDataTableModel = new CachedDataTableModel();
        this.dataTable.setModel(this.cachedDataTableModel);
        this.actionButton.setText(this.startCacheButtonLabel);
        this.cacheStatus.setText(this.statusStopped);
        this.actionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfinispanDemo.this.actionButton.getText().equals(InfinispanDemo.this.startCacheButtonLabel)) {
                    InfinispanDemo.this.startCache();
                } else if (InfinispanDemo.this.actionButton.getText().equals(InfinispanDemo.this.stopCacheButtonLabel)) {
                    InfinispanDemo.this.stopCache();
                }
            }
        });
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.processAction(InfinispanDemo.this.goButton, true);
                InfinispanDemo.this.asyncExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            if (InfinispanDemo.this.putEntryRadioButton.isSelected()) {
                                InfinispanDemo.this.cache.put((Object)InfinispanDemo.this.keyTextField.getText(), (Object)InfinispanDemo.this.valueTextField.getText(), this.lifespan(), TimeUnit.MILLISECONDS, this.maxIdle(), TimeUnit.MILLISECONDS);
                            } else if (InfinispanDemo.this.removeEntryRadioButton.isSelected()) {
                                InfinispanDemo.this.cache.remove((Object)InfinispanDemo.this.keyTextField.getText());
                            } else if (InfinispanDemo.this.getEntryRadioButton.isSelected()) {
                                InfinispanDemo.this.cache.get((Object)InfinispanDemo.this.keyTextField.getText());
                            }
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            InfinispanDemo.this.dataViewTab.repaint();
                            InfinispanDemo.this.processAction(InfinispanDemo.this.goButton, false);
                        }
                        InfinispanDemo.this.lifespanSpinner.setValue(InfinispanDemo.this.cache.getCacheConfiguration().expiration().lifespan());
                        InfinispanDemo.this.maxIdleSpinner.setValue(InfinispanDemo.this.cache.getCacheConfiguration().expiration().maxIdle());
                        InfinispanDemo.this.mainPane.setSelectedIndex(1);
                    }

                    private long lifespan() {
                        try {
                            String s = InfinispanDemo.this.lifespanSpinner.getValue().toString();
                            return Long.parseLong(s);
                        }
                        catch (Exception e) {
                            return InfinispanDemo.this.cache.getCacheConfiguration().expiration().lifespan();
                        }
                    }

                    private long maxIdle() {
                        try {
                            String s = InfinispanDemo.this.maxIdleSpinner.getValue().toString();
                            return Long.parseLong(s);
                        }
                        catch (Exception e) {
                            return InfinispanDemo.this.cache.getCacheConfiguration().expiration().maxIdle();
                        }
                    }
                });
            }
        });
        this.removeEntryRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.keyTextField.setEnabled(true);
                InfinispanDemo.this.valueTextField.setEnabled(false);
                InfinispanDemo.this.lifespanSpinner.setEnabled(false);
                InfinispanDemo.this.maxIdleSpinner.setEnabled(false);
            }
        });
        this.putEntryRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.keyTextField.setEnabled(true);
                InfinispanDemo.this.valueTextField.setEnabled(true);
                InfinispanDemo.this.lifespanSpinner.setEnabled(true);
                InfinispanDemo.this.maxIdleSpinner.setEnabled(true);
            }
        });
        this.getEntryRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.keyTextField.setEnabled(true);
                InfinispanDemo.this.valueTextField.setEnabled(false);
                InfinispanDemo.this.lifespanSpinner.setEnabled(false);
                InfinispanDemo.this.maxIdleSpinner.setEnabled(false);
            }
        });
        this.generateSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                InfinispanDemo.this.randomGeneratorButton.setText("Generate " + InfinispanDemo.this.generateSlider.getValue() + " Random Entries");
            }
        });
        this.randomGeneratorButton.setText("Generate " + this.generateSlider.getValue() + " Random Entries");
        this.randomGeneratorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.processAction(InfinispanDemo.this.randomGeneratorButton, true);
                InfinispanDemo.this.asyncExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        int entries = InfinispanDemo.this.generateSlider.getValue();
                        if (entries > 1000) {
                            for (int i = 0; i < entries / 1000; ++i) {
                                HashMap<String, String> rand = new HashMap<String, String>();
                                while (rand.size() < 1000) {
                                    rand.put(this.randomString(), this.randomString());
                                }
                                InfinispanDemo.this.cache.putAll(rand);
                            }
                            entries %= 1000;
                        }
                        HashMap<String, String> rand = new HashMap<String, String>();
                        while (rand.size() < entries) {
                            rand.put(this.randomString(), this.randomString());
                        }
                        InfinispanDemo.this.cache.putAll(rand);
                        InfinispanDemo.this.processAction(InfinispanDemo.this.randomGeneratorButton, false);
                        InfinispanDemo.this.generateSlider.setValue(50);
                        InfinispanDemo.this.mainPane.setSelectedIndex(1);
                    }
                });
            }

            private String randomString() {
                return Integer.toHexString(InfinispanDemo.this.r.nextInt(Integer.MAX_VALUE)).toUpperCase();
            }
        });
        this.cacheClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.processAction(InfinispanDemo.this.cacheClearButton, true);
                InfinispanDemo.this.asyncExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InfinispanDemo.this.cache.clear();
                        InfinispanDemo.this.processAction(InfinispanDemo.this.cacheClearButton, false);
                        InfinispanDemo.this.mainPane.setSelectedIndex(1);
                    }
                });
            }
        });
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfinispanDemo.this.processAction(InfinispanDemo.this.refreshButton, true);
                InfinispanDemo.this.asyncExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        InfinispanDemo.this.updateCachedDataTable();
                        InfinispanDemo.this.processAction(InfinispanDemo.this.refreshButton, false);
                        InfinispanDemo.this.mainPane.setSelectedIndex(1);
                    }
                });
            }
        });
    }

    private void moveCacheToState(ComponentStatus state) {
        switch (state) {
            case INITIALIZING: {
                this.cacheStatus.setText(this.statusStarting);
                this.processAction(this.actionButton, true);
                break;
            }
            case RUNNING: {
                this.setCacheTabsStatus(true);
                this.actionButton.setText(this.stopCacheButtonLabel);
                this.processAction(this.actionButton, false);
                this.cacheStatus.setText(this.statusStarted);
                this.updateTitleBar();
                break;
            }
            case STOPPING: {
                this.cacheStatus.setText(this.statusStopping);
                this.processAction(this.actionButton, true);
                break;
            }
            case TERMINATED: {
                this.setCacheTabsStatus(false);
                this.actionButton.setText(this.startCacheButtonLabel);
                this.processAction(this.actionButton, false);
                this.cacheStatus.setText(this.statusStopped);
                this.updateTitleBar();
            }
        }
        this.controlPanelTab.repaint();
    }

    private void processAction(JButton button, boolean start) {
        button.setEnabled(!start);
        this.cacheStatusProgressBar.setVisible(start);
        this.cacheStatusProgressBar.setEnabled(start);
    }

    private String readContents(InputStream is) throws IOException {
        String s;
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((s = r.readLine()) != null) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    private void startCache() {
        this.moveCacheToState(ComponentStatus.INITIALIZING);
        this.asyncExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    URL resource = this.getClass().getClassLoader().getResource(InfinispanDemo.this.cacheConfigFile);
                    if (resource == null) {
                        resource = new URL(InfinispanDemo.this.cacheConfigFile);
                    }
                    if (InfinispanDemo.this.cacheManager == null) {
                        InputStream stream = resource.openStream();
                        try {
                            InfinispanDemo.this.cacheManager = new DefaultCacheManager(stream);
                        }
                        finally {
                            Util.close((Closeable)stream);
                        }
                    }
                    InfinispanDemo.this.cache = InfinispanDemo.this.cacheManager.getCache();
                    InfinispanDemo.this.cache.start();
                    InfinispanDemo.this.configFileName.setText(resource.toString());
                    InfinispanDemo.this.configFileName.repaint();
                    InputStream is = null;
                    try {
                        is = resource.openStream();
                        InfinispanDemo.this.configFileContents.setText(InfinispanDemo.this.readContents(is));
                        InfinispanDemo.this.configFileContents.setEditable(false);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Unable to open config file [" + InfinispanDemo.this.cacheConfigFile + "] for display"), (Throwable)e);
                    }
                    finally {
                        Util.close((Closeable)is);
                    }
                    InfinispanDemo.this.configFileContents.repaint();
                    CacheListener cl = new CacheListener();
                    InfinispanDemo.this.cache.addListener((Object)cl);
                    EmbeddedCacheManager cacheManager = InfinispanDemo.this.cache.getCacheManager();
                    cacheManager.addListener((Object)cl);
                    InfinispanDemo.this.updateClusterTable(cacheManager.getMembers());
                    InfinispanDemo.this.lifespanSpinner.setValue(InfinispanDemo.this.cache.getCacheConfiguration().expiration().lifespan());
                    InfinispanDemo.this.maxIdleSpinner.setValue(InfinispanDemo.this.cache.getCacheConfiguration().expiration().maxIdle());
                    InfinispanDemo.this.cacheContentsSizeLabel.setText("Cache contains " + InfinispanDemo.this.cache.size() + " entries");
                    InfinispanDemo.this.moveCacheToState(ComponentStatus.RUNNING);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to start cache!", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void stopCache() {
        this.moveCacheToState(ComponentStatus.STOPPING);
        this.asyncExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (InfinispanDemo.this.cache != null) {
                    InfinispanDemo.this.cache.stop();
                    InfinispanDemo.this.cache = null;
                }
                if (InfinispanDemo.this.cacheManager != null) {
                    InfinispanDemo.this.cacheManager.stop();
                    InfinispanDemo.this.cacheManager = null;
                }
                InfinispanDemo.this.cachedDataTableModel.reset();
                InfinispanDemo.this.configFileContents.setText("");
                InfinispanDemo.this.configFileContents.repaint();
                InfinispanDemo.this.configFileName.setText("");
                InfinispanDemo.this.configFileName.repaint();
                InfinispanDemo.this.moveCacheToState(ComponentStatus.TERMINATED);
            }
        });
    }

    private void setCacheTabsStatus(boolean enabled) {
        int numTabs = this.mainPane.getTabCount();
        for (int i = 1; i < numTabs; ++i) {
            this.mainPane.setEnabledAt(i, enabled);
        }
        this.panel1.repaint();
    }

    private void updateClusterTable(List<Address> members) {
        log.debug((Object)("Updating cluster table with new member list " + members));
        this.clusterTableModel.setMembers(members);
        this.updateTitleBar();
    }

    private void updateTitleBar() {
        String title = "Infinispan GUI Demo";
        title = this.cache != null && this.cache.getStatus() == ComponentStatus.RUNNING ? title + " (STARTED) " + this.getLocalAddress() + " Cluster size: " + this.getClusterSize() : title + " (STOPPED)";
        frame.setTitle(title);
    }

    private String getLocalAddress() {
        EmbeddedCacheManager cacheManager = this.cache.getCacheManager();
        Address a = cacheManager.getAddress();
        if (a == null) {
            return "(LOCAL mode)";
        }
        return a.toString();
    }

    private String getClusterSize() {
        EmbeddedCacheManager cacheManager = this.cache.getCacheManager();
        List members = cacheManager.getMembers();
        return members == null || members.isEmpty() ? "N/A" : "" + members.size();
    }

    private void createUIComponents() {
        this.dataTable = new AlternateColorTable();
    }

    private void updateCachedDataTable() {
        this.tableUpdateExecutor.execute(new Runnable(){

            @Override
            public void run() {
                InfinispanDemo.this.cachedDataTableModel.update();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JProgressBar jProgressBar;
        JLabel jLabel;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JSlider jSlider;
        JButton jButton;
        JButton jButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JButton jButton3;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JTable jTable;
        JPanel jPanel2;
        JLabel jLabel2;
        JButton jButton4;
        JPanel jPanel3;
        JPanel jPanel4;
        JTextArea jTextArea;
        JLabel jLabel3;
        JButton jButton5;
        JPanel jPanel5;
        JTabbedPane jTabbedPane;
        JPanel jPanel6;
        this.createUIComponents();
        this.panel1 = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new FormLayout("fill:800px:grow,left:4dlu:noGrow,fill:100px:grow", "center:max(d;4px):noGrow,top:3dlu:noGrow,center:600px:grow,top:3dlu:noGrow,center:max(d;4px):noGrow"));
        Font font = jPanel6.getFont();
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(-16750951)), "Infinispan GUI Demo Application", 0, 0, new Font(font.getName(), 3, 14), new Color(-16750951)));
        this.mainPane = jTabbedPane = new JTabbedPane();
        jPanel6.add((Component)jTabbedPane, new CellConstraints(1, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.controlPanelTab = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:max(d;4px):noGrow,left:4dlu:noGrow,fill:d:grow", "center:m:noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow"));
        jPanel5.setToolTipText("");
        jTabbedPane.addTab("Control panel", null, jPanel5, "This tab contains cache controls and general information about the cache configuration.");
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Command");
        Font font2 = jLabel4.getFont();
        jLabel4.setFont(new Font(font2.getName(), 1, font2.getSize()));
        jPanel5.add((Component)jLabel4, new CellConstraints(1, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.actionButton = jButton5 = new JButton();
        jButton5.setText("Button");
        jPanel5.add((Component)jButton5, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Cache configuration file");
        Font font3 = jLabel5.getFont();
        jLabel5.setFont(new Font(font3.getName(), 1, font3.getSize()));
        jPanel5.add((Component)jLabel5, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        this.configFileName = jLabel3 = new JLabel();
        jLabel3.setText(" ");
        Font font4 = jLabel3.getFont();
        jLabel3.setFont(new Font(font4.getName(), 3, font4.getSize()));
        jPanel5.add((Component)jLabel3, new CellConstraints(3, 3, 3, 1, CellConstraints.DEFAULT, CellConstraints.TOP, new Insets(0, 0, 0, 0)));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel5.add((Component)jScrollPane, new CellConstraints(3, 5, 3, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.configFileContents = jTextArea = new JTextArea();
        jTextArea.setText("");
        Font font5 = jTextArea.getFont();
        jTextArea.setFont(new Font("Courier New", font5.getStyle(), 10));
        ((Component)jTextArea).setBackground(new Color(-3355444));
        jScrollPane.setViewportView(jTextArea);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Note that you can specify a configuration file to use by passing in -Dinfinispan.configuration=file:/path/to/config.xml");
        Font font6 = jLabel6.getFont();
        jLabel6.setFont(new Font(font6.getName(), 2, 12));
        jPanel5.add((Component)jLabel6, new CellConstraints(5, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.dataViewTab = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.setToolTipText("");
        ((Component)jPanel4).setEnabled(true);
        jTabbedPane.addTab("Data view", null, jPanel4, "This tab contains a view of all the data in the cache.");
        jTabbedPane.setEnabledAt(1, false);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        ((Component)jScrollPane2).setBackground(new Color(-1118482));
        jPanel4.add((Component)jScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JTable jTable2 = this.dataTable;
        jScrollPane2.setViewportView(jTable2);
        this.dataViewControlPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.refreshButton = jButton4 = new JButton();
        jButton4.setText("Refresh view");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(100, -1), new Dimension(150, -1)));
        this.cacheContentsSizeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Blah");
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.clusterViewTab = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new FormLayout("fill:d:grow", "center:d:grow"));
        jPanel2.setToolTipText("");
        jTabbedPane.addTab("Cluster view", null, jPanel2, "This tab contains a view of the cluster topology");
        jTabbedPane.setEnabledAt(2, false);
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.setHorizontalScrollBarPolicy(30);
        ((Component)jScrollPane3).setBackground(new Color(-1118482));
        jPanel2.add((Component)jScrollPane3, new CellConstraints(1, 1, 1, 1, CellConstraints.FILL, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.clusterTable = jTable = new JTable();
        jTable.setShowHorizontalLines(true);
        ((Component)jTable).setBackground(new Color(-992313));
        jTable.setGridColor(new Color(-16777216));
        jTable.setShowVerticalLines(false);
        jTable.setIntercellSpacing(new Dimension(3, 3));
        jScrollPane3.setViewportView(jTable);
        this.dataGeneratorTab = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new FormLayout("fill:d:noGrow,left:4dlu:noGrow,fill:200px:noGrow,left:4dlu:noGrow,fill:200px:grow", "center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:max(d;4px):noGrow,top:3dlu:noGrow,center:d:grow"));
        jPanel.setToolTipText("");
        jTabbedPane.addTab("Manipulate data", null, jPanel, "This tab provides you with the ability to add or remove data from the cache.");
        jTabbedPane.setEnabledAt(3, false);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Key");
        jPanel.add((Component)jLabel7, new CellConstraints(1, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Value");
        jPanel.add((Component)jLabel8, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.keyTextField = jTextField2 = new JTextField();
        jTextField2.setToolTipText("Cached entry key");
        jPanel.add((Component)jTextField2, new CellConstraints(3, 3, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.valueTextField = jTextField = new JTextField();
        jTextField.setToolTipText("Cached entry value");
        jPanel.add((Component)jTextField, new CellConstraints(3, 5, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Single entry manipulator");
        Font font7 = jLabel9.getFont();
        jLabel9.setFont(new Font(font7.getName(), 3, font7.getSize()));
        jPanel.add((Component)jLabel9, new CellConstraints(3, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Random data generator");
        Font font8 = jLabel10.getFont();
        jLabel10.setFont(new Font(font8.getName(), 3, font8.getSize()));
        jPanel.add((Component)jLabel10, new CellConstraints(3, 13, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Max entries");
        jPanel.add((Component)jLabel11, new CellConstraints(1, 15, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.cacheClearButton = jButton3 = new JButton();
        jButton3.setToolTipText("Clears all caches");
        jButton3.setText("Clear cache");
        jButton3.setMnemonic('L');
        jButton3.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jButton3, new CellConstraints(3, 21, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("Clear cache");
        Font font9 = jLabel12.getFont();
        jLabel12.setFont(new Font(font9.getName(), 3, font9.getSize()));
        jPanel.add((Component)jLabel12, new CellConstraints(3, 19, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("MaxIdle (millis)");
        jPanel.add((Component)jLabel13, new CellConstraints(1, 9, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        JLabel jLabel14 = new JLabel();
        jLabel14.setText("Lifespan (millis)");
        jPanel.add((Component)jLabel14, new CellConstraints(1, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.putEntryRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setToolTipText("Adds a new entry or overwrites an existing one");
        jRadioButton3.setText("Put Entry");
        jRadioButton3.setMnemonic('P');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jRadioButton3.setSelected(true);
        jPanel.add((Component)jRadioButton3, new CellConstraints(5, 3, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.getEntryRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setToolTipText("Retrieves a cache entry, potentially from a remote cache");
        jRadioButton2.setText("Get Entry");
        jRadioButton2.setMnemonic('G');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton2, new CellConstraints(5, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.removeEntryRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setToolTipText("Removes an entry from the cache");
        jRadioButton.setText("Remove Entry");
        jRadioButton.setMnemonic('R');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jRadioButton, new CellConstraints(5, 7, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.goButton = jButton2 = new JButton();
        jButton2.setToolTipText("Perform operation");
        jButton2.setText("Go");
        jButton2.setMnemonic('G');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new CellConstraints(5, 9, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.randomGeneratorButton = jButton = new JButton();
        jButton.setToolTipText("Generates random data");
        jButton.setText("Generate");
        jButton.setMnemonic('N');
        jButton.setDisplayedMnemonicIndex(2);
        jPanel.add((Component)jButton, new CellConstraints(5, 15, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.generateSlider = jSlider = new JSlider();
        jSlider.setMinimum(1);
        jSlider.setMaximum(1000);
        jSlider.setValueIsAdjusting(true);
        jSlider.setPaintTicks(true);
        jSlider.setMinorTickSpacing(100);
        jSlider.setPaintLabels(true);
        jPanel.add((Component)jSlider, new CellConstraints(3, 15, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.lifespanSpinner = jSpinner2 = new JSpinner();
        jSpinner2.setToolTipText("Lifespan of the cache entry, in milliseconds.  Defaults to what is declared in XML config.  -1 is immortal.");
        jPanel.add((Component)jSpinner2, new CellConstraints(3, 7, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.maxIdleSpinner = jSpinner = new JSpinner();
        jSpinner.setToolTipText("MaxIdle of the cache entry, in milliseconds.  Defaults to what is declared in XML config.  -1 is immortal.");
        jPanel.add((Component)jSpinner, new CellConstraints(3, 9, 1, 1, CellConstraints.FILL, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new CellConstraints(1, 23, 5, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new CellConstraints(1, 17, 5, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        Spacer spacer5 = new Spacer();
        jPanel.add((Component)spacer5, new CellConstraints(1, 11, 5, 1, CellConstraints.DEFAULT, CellConstraints.FILL, new Insets(0, 0, 0, 0)));
        this.cacheStatus = jLabel = new JLabel();
        jLabel.setText("Initializing");
        Font font10 = jLabel.getFont();
        jLabel.setFont(new Font(font10.getName(), 3, font10.getSize()));
        jLabel.setToolTipText("Cache status");
        jLabel.setVerticalAlignment(3);
        jPanel6.add((Component)jLabel, new CellConstraints(1, 5, 1, 1, CellConstraints.DEFAULT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        this.cacheStatusProgressBar = jProgressBar = new JProgressBar();
        jProgressBar.setOrientation(0);
        jProgressBar.setIndeterminate(true);
        jPanel6.add((Component)jProgressBar, new CellConstraints(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.DEFAULT, new Insets(0, 0, 0, 0)));
        jLabel7.setLabelFor(jTextField2);
        jLabel8.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel1;
    }

    class CachedEntry {
        String key;
        String value;
        long lifespan = -1L;
        long maxIdle = -1L;

        CachedEntry() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedEntry that = (CachedEntry)o;
            if (this.lifespan != that.lifespan) {
                return false;
            }
            if (this.maxIdle != that.maxIdle) {
                return false;
            }
            if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (int)(this.lifespan ^ this.lifespan >>> 32);
            result = 31 * result + (int)(this.maxIdle ^ this.maxIdle >>> 32);
            return result;
        }
    }

    public class CachedDataTableModel
    extends AbstractTableModel {
        List<InternalCacheEntry> data = new ArrayList<InternalCacheEntry>();
        private static final long serialVersionUID = -7109980678271415778L;

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.data.size() > rowIndex) {
                InternalCacheEntry e = this.data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return e.getKey();
                    }
                    case 1: {
                        return e.getValue();
                    }
                    case 2: {
                        return e.getLifespan();
                    }
                    case 3: {
                        return e.getMaxIdle();
                    }
                }
            }
            return "NULL!";
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return "Key";
                }
                case 1: {
                    return "Value";
                }
                case 2: {
                    return "Lifespan";
                }
                case 3: {
                    return "MaxIdle";
                }
            }
            return "NULL!";
        }

        public void update() {
            this.data.clear();
            long currentTimeMillis = System.currentTimeMillis();
            for (InternalCacheEntry ice : InfinispanDemo.this.cache.getAdvancedCache().getDataContainer()) {
                if (ice.isExpired(currentTimeMillis)) continue;
                this.data.add(ice);
            }
            InfinispanDemo.this.cacheContentsSizeLabel.setText("Cache contains " + this.data.size() + " entries");
            this.fireTableDataChanged();
        }

        public void reset() {
            this.data.clear();
            InfinispanDemo.this.cacheContentsSizeLabel.setText("Cache contains " + this.data.size() + " entries");
            this.fireTableDataChanged();
        }
    }

    public class ClusterTableModel
    extends AbstractTableModel {
        List<String> members = new ArrayList<String>();
        List<String> memberStates = new ArrayList<String>();
        private static final long serialVersionUID = -4321027648450429007L;

        public void setMembers(List<Address> m) {
            if (m != null && !m.isEmpty()) {
                this.members = new ArrayList<String>(m.size());
                for (Address ma : m) {
                    this.members.add(ma.toString());
                }
                this.memberStates = new ArrayList<String>(m.size());
                for (Address a : m) {
                    EmbeddedCacheManager cacheManager;
                    String extraInfo = "Member";
                    if (this.memberStates.isEmpty()) {
                        extraInfo = extraInfo + " (coord)";
                    }
                    if (a.equals((cacheManager = InfinispanDemo.this.cache.getCacheManager()).getAddress())) {
                        extraInfo = extraInfo + " (me)";
                    }
                    this.memberStates.add(extraInfo);
                }
            } else {
                this.members = Collections.singletonList("me!");
                this.memberStates = Collections.singletonList("(local mode)");
            }
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.members.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.members.get(rowIndex);
                }
                case 1: {
                    return this.memberStates.get(rowIndex);
                }
            }
            return "NULL!";
        }

        @Override
        public String getColumnName(int c) {
            if (c == 0) {
                return "Member Address";
            }
            if (c == 1) {
                return "Member Info";
            }
            return "NULL!";
        }
    }

    @Listener(sync=true)
    public class CacheListener {
        @ViewChanged
        @Merged
        public void viewChangeEvent(ViewChangedEvent e) {
            InfinispanDemo.this.updateClusterTable(e.getNewMembers());
        }

        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntriesEvicted
        public void removed(Event<?, ?> e) {
            if (!e.isPre()) {
                InfinispanDemo.this.updateCachedDataTable();
            }
        }
    }

    public static class AlternateColorTable
    extends JTable {
        final Color c1 = new Color(238, 238, 238);
        final Color c2 = new Color(255, 255, 238);

        protected Color colorForRow(int row) {
            return row % 2 == 0 ? this.c1 : this.c2;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (!this.isCellSelected(row, column)) {
                c.setBackground(this.colorForRow(row));
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(UIManager.getColor("Table.selectionBackground"));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            return c;
        }
    }
}

