/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.tom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.tom.DeliveryManager;
import org.jgroups.protocols.tom.MessageID;
import org.jgroups.protocols.tom.SequenceNumberManager;
import org.jgroups.protocols.tom.ToaHeader;

public class DeliveryManagerImpl
implements DeliveryManager {
    private final SortedSet<MessageInfo> deliverySet = new TreeSet<MessageInfo>();
    private final ConcurrentMap<MessageID, MessageInfo> messageCache = new ConcurrentHashMap<MessageID, MessageInfo>();
    private final SequenceNumberManager sequenceNumberManager = new SequenceNumberManager();
    private final Set<Address> currentView = new HashSet<Address>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleView(View newView) {
        LinkedList toRemove = new LinkedList();
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.updateMembers(newView);
            this.deliverySet.stream().filter(this::shouldRemove).forEach(toRemove::add);
            this.deliverySet.removeAll(toRemove);
            this.notifyIfNeeded();
        }
        for (MessageInfo removed : toRemove) {
            this.messageCache.remove(removed.messageID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addLocalMessageToDeliver(MessageID messageID, Message message, ToaHeader header) {
        MessageInfo messageInfo;
        long sequenceNumber;
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            sequenceNumber = this.sequenceNumberManager.getAndIncrement();
            messageInfo = new MessageInfo(messageID, message, sequenceNumber);
            this.deliverySet.add(messageInfo);
        }
        header.setSequencerNumber(sequenceNumber);
        this.messageCache.put(messageID, messageInfo);
        return sequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long addRemoteMessageToDeliver(MessageID messageID, Message message, long remoteSequenceNumber) {
        MessageInfo messageInfo;
        long sequenceNumber;
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            if (!this.currentView.contains(message.getSrc())) {
                return -1L;
            }
            sequenceNumber = this.sequenceNumberManager.updateAndGet(remoteSequenceNumber);
            messageInfo = new MessageInfo(messageID, message, sequenceNumber);
            this.deliverySet.add(messageInfo);
        }
        this.messageCache.put(messageID, messageInfo);
        return sequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSequenceNumber(long sequenceNumber) {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.sequenceNumberManager.update(sequenceNumber);
        }
    }

    void markReadyToDeliver(MessageID messageID, long finalSequenceNumber) {
        this.markReadyToDeliverV2(messageID, finalSequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverSingleDestinationMessage(Message msg, MessageID messageID) {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            long sequenceNumber = this.sequenceNumberManager.get();
            MessageInfo messageInfo = new MessageInfo(messageID, msg, sequenceNumber);
            messageInfo.updateAndMarkReadyToDeliver(sequenceNumber);
            this.deliverySet.add(messageInfo);
            this.notifyIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<MessageInfo> getMessageSet() {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            return Collections.unmodifiableSet(this.deliverySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markReadyToDeliverV2(MessageID messageID, long finalSequenceNumber) {
        MessageInfo messageInfo = (MessageInfo)this.messageCache.remove(messageID);
        if (messageInfo == null) {
            throw new IllegalStateException("Message ID not found in to deliver list. this can't happen. Message ID is " + messageID);
        }
        boolean needsUpdatePosition = messageInfo.isUpdatePositionNeeded(finalSequenceNumber);
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.sequenceNumberManager.update(finalSequenceNumber);
            if (needsUpdatePosition) {
                this.deliverySet.remove(messageInfo);
                messageInfo.updateAndMarkReadyToDeliver(finalSequenceNumber);
                this.deliverySet.add(messageInfo);
            } else {
                messageInfo.updateAndMarkReadyToDeliver(finalSequenceNumber);
            }
            this.notifyIfNeeded();
        }
    }

    private void updateMembers(View newView) {
        this.currentView.clear();
        this.currentView.addAll(newView.getMembers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Message> getNextMessagesToDeliver() throws InterruptedException {
        LinkedList<Message> toDeliver = new LinkedList<Message>();
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            MessageInfo messageInfo;
            while (this.deliverySet.isEmpty() || !this.deliverySet.first().isReadyToDeliver()) {
                this.deliverySet.wait();
            }
            Iterator iterator = this.deliverySet.iterator();
            while (iterator.hasNext() && (messageInfo = (MessageInfo)iterator.next()).isReadyToDeliver()) {
                toDeliver.add(messageInfo.getMessage());
                iterator.remove();
            }
        }
        return toDeliver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MessageInfo> getAllMessages() {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            return new ArrayList<MessageInfo>(this.deliverySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        SortedSet<MessageInfo> sortedSet = this.deliverySet;
        synchronized (sortedSet) {
            this.deliverySet.clear();
            this.messageCache.clear();
        }
    }

    public SequenceNumberManager getSequenceNumberManager() {
        return this.sequenceNumberManager;
    }

    private boolean shouldRemove(MessageInfo messageInfo) {
        return !this.currentView.contains(messageInfo.getMessage().getSrc()) && !messageInfo.isReadyToDeliver();
    }

    private void notifyIfNeeded() {
        if (!this.deliverySet.isEmpty() && this.deliverySet.first().isReadyToDeliver()) {
            this.deliverySet.notify();
        }
    }

    public static class MessageInfo
    implements Comparable<MessageInfo> {
        private final MessageID messageID;
        private final Message message;
        private volatile long sequenceNumber;
        private volatile boolean readyToDeliver;

        MessageInfo(MessageID messageID, Message message, long sequenceNumber) {
            if (messageID == null) {
                throw new NullPointerException("Message ID can't be null");
            }
            this.messageID = messageID;
            this.message = message.copy(true, true);
            this.sequenceNumber = sequenceNumber;
            this.readyToDeliver = false;
            this.message.setSrc(messageID.getAddress());
        }

        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        private Message getMessage() {
            return this.message;
        }

        private boolean isUpdatePositionNeeded(long finalSequenceNumber) {
            return this.sequenceNumber != finalSequenceNumber;
        }

        public boolean isReadyToDeliver() {
            return this.readyToDeliver;
        }

        public boolean equals(Object o) {
            boolean isMessageID;
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            boolean bl = isMessageID = o.getClass() == MessageID.class;
            if (o.getClass() != this.getClass() && !isMessageID) {
                return false;
            }
            if (isMessageID) {
                return this.messageID.equals(o);
            }
            MessageInfo that = (MessageInfo)o;
            return this.messageID.equals(that.messageID);
        }

        public int hashCode() {
            return this.messageID.hashCode();
        }

        public String toString() {
            return "MessageInfo{messageID=" + this.messageID + ", sequenceNumber=" + this.sequenceNumber + ", readyToDeliver=" + this.readyToDeliver + '}';
        }

        private void updateAndMarkReadyToDeliver(long finalSequenceNumber) {
            this.readyToDeliver = true;
            this.sequenceNumber = finalSequenceNumber;
        }

        @Override
        public int compareTo(MessageInfo o) {
            if (o == null) {
                throw new NullPointerException();
            }
            int sameId = this.messageID.compareTo(o.messageID);
            if (sameId == 0) {
                return 0;
            }
            return this.sequenceNumber < o.sequenceNumber ? -1 : (this.sequenceNumber == o.sequenceNumber ? sameId : 1);
        }
    }
}

