/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.lang.invoke.MethodHandles;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalStateConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class GlobalStateConfigurationBuilder
extends AbstractGlobalConfigurationBuilder
implements Builder<GlobalStateConfiguration> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final AttributeSet attributes = GlobalStateConfiguration.attributeDefinitionSet();

    GlobalStateConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public GlobalStateConfigurationBuilder enable() {
        return this.enabled(true);
    }

    public GlobalStateConfigurationBuilder disable() {
        return this.enabled(false);
    }

    public GlobalStateConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(GlobalStateConfiguration.ENABLED).set(enabled);
        return this;
    }

    public boolean enabled() {
        return this.attributes.attribute(GlobalStateConfiguration.ENABLED).get();
    }

    public GlobalStateConfigurationBuilder persistentLocation(String location) {
        this.attributes.attribute(GlobalStateConfiguration.PERSISTENT_LOCATION).set(location);
        return this;
    }

    public GlobalStateConfigurationBuilder temporaryLocation(String location) {
        this.attributes.attribute(GlobalStateConfiguration.TEMPORARY_LOCATION).set(location);
        return this;
    }

    @Override
    public void validate() {
        if (this.attributes.attribute(GlobalStateConfiguration.ENABLED).get().booleanValue() && this.attributes.attribute(GlobalStateConfiguration.PERSISTENT_LOCATION).isNull()) {
            log.missingGlobalStatePersistentLocation();
        }
    }

    @Override
    public GlobalStateConfiguration create() {
        return new GlobalStateConfiguration(this.attributes.protect());
    }

    @Override
    public Builder<?> read(GlobalStateConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }
}

