package org.jgroups.tests;

import org.jgroups.ReceiverAdapter;
import org.jgroups.util.Util;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla10 extends ReceiverAdapter {
    protected Lock lock=new ReentrantLock();
    protected Condition cond=lock.newCondition();


    public static void main(String[] args) {
        new bla10().start();
    }

    private void start() {

        Thread waiter=new Thread(() -> {
            lock.lock();
            try {
                System.out.printf("waiting\n");
                cond.await();
                System.out.printf("done waiting\n");
            }
            catch(InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                lock.unlock();
            }
        });



        // Util.sleep(1000);
        lock.lock();
        try {
            cond.signalAll();
        }
        finally {
            lock.unlock();
        }

        waiter.start();


    }


}
