/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.offheap.Bits;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.TimeService;

public class OffHeapEntryFactoryImpl
implements OffHeapEntryFactory {
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private Marshaller marshaller;
    private OffHeapMemoryAllocator allocator;
    private TimeService timeService;
    private InternalEntryFactory internalEntryFactory;
    private boolean evictionEnabled;
    private static final byte CUSTOM = 1;
    private static final byte HAS_VERSION = 2;
    private static final byte IMMORTAL = 4;
    private static final byte MORTAL = 8;
    private static final byte TRANSIENT = 16;
    private static final byte TRANSIENT_MORTAL = 32;
    private static final int HEADER_LENGTH = 17;

    @Inject
    public void inject(Marshaller marshaller, OffHeapMemoryAllocator allocator, TimeService timeService, InternalEntryFactory internalEntryFactory, Configuration configuration) {
        this.marshaller = marshaller;
        this.allocator = allocator;
        this.timeService = timeService;
        this.internalEntryFactory = internalEntryFactory;
        this.evictionEnabled = configuration.memory().isEvictionEnabled();
    }

    @Override
    public long create(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        byte[] metadataBytes;
        byte type;
        if (metadata instanceof EmbeddedMetadata) {
            byte[] versionBytes;
            EntryVersion version = metadata.version();
            if (version != null) {
                type = 2;
                try {
                    versionBytes = this.marshaller.objectToByteBuffer(version);
                }
                catch (IOException | InterruptedException e) {
                    throw new CacheException(e);
                }
            } else {
                type = 0;
                versionBytes = EMPTY_BYTES;
            }
            long lifespan = metadata.lifespan();
            long maxIdle = metadata.maxIdle();
            if (lifespan < 0L && maxIdle < 0L) {
                type = (byte)(type | 4);
                metadataBytes = versionBytes;
            } else if (lifespan > -1L && maxIdle < 0L) {
                type = (byte)(type | 8);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, lifespan);
                Bits.putLong(metadataBytes, 8, this.timeService.wallClockTime());
                System.arraycopy(versionBytes, 0, metadataBytes, 16, versionBytes.length);
            } else if (lifespan < 0L && maxIdle > -1L) {
                type = (byte)(type | 0x10);
                metadataBytes = new byte[16 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, maxIdle);
                Bits.putLong(metadataBytes, 8, this.timeService.wallClockTime());
                System.arraycopy(versionBytes, 0, metadataBytes, 16, versionBytes.length);
            } else {
                type = (byte)(type | 0x20);
                metadataBytes = new byte[32 + versionBytes.length];
                Bits.putLong(metadataBytes, 0, maxIdle);
                Bits.putLong(metadataBytes, 8, lifespan);
                long time = this.timeService.wallClockTime();
                Bits.putLong(metadataBytes, 16, time);
                Bits.putLong(metadataBytes, 24, time);
                System.arraycopy(versionBytes, 0, metadataBytes, 32, versionBytes.length);
            }
        } else {
            type = 1;
            try {
                metadataBytes = this.marshaller.objectToByteBuffer(metadata);
            }
            catch (IOException | InterruptedException e) {
                throw new CacheException(e);
            }
        }
        int keySize = key.getLength();
        int metadataSize = metadataBytes.length;
        int valueSize = value.getLength();
        int headerOffset = this.evictionEnabled ? 8 : 0;
        long totalSize = 8 + headerOffset + 17 + keySize + metadataSize + valueSize;
        long memoryAddress = this.allocator.allocate(totalSize + (long)headerOffset);
        int offset = this.evictionEnabled ? 8 : 0;
        MEMORY.putLong(memoryAddress, offset, 0L);
        MEMORY.putInt(memoryAddress, offset += 8, key.hashCode());
        MEMORY.putInt(memoryAddress, offset += 4, key.getLength());
        MEMORY.putInt(memoryAddress, offset += 4, metadataBytes.length);
        MEMORY.putInt(memoryAddress, offset += 4, value.getLength());
        MEMORY.putByte(memoryAddress, offset += 4, type);
        MEMORY.putBytes(key.getBytes(), key.backArrayOffset(), memoryAddress, ++offset, keySize);
        MEMORY.putBytes(metadataBytes, 0L, memoryAddress, offset += keySize, metadataSize);
        MEMORY.putBytes(value.getBytes(), value.backArrayOffset(), memoryAddress, offset += metadataSize, valueSize);
        assert ((long)(offset += valueSize) == totalSize);
        return memoryAddress;
    }

    @Override
    public long getSize(long entryAddress) {
        int headerOffset = this.evictionEnabled ? 16 : 8;
        int keyLength = MEMORY.getInt(entryAddress, headerOffset + 4);
        int metadataLength = MEMORY.getInt(entryAddress, headerOffset + 8);
        int valueLength = MEMORY.getInt(entryAddress, headerOffset + 12);
        return headerOffset + 17 + keyLength + metadataLength + valueLength;
    }

    @Override
    public long getNext(long entryAddress) {
        return MEMORY.getLong(entryAddress, this.evictionEnabled ? 8L : 0L);
    }

    @Override
    public void setNext(long entryAddress, long value) {
        MEMORY.putLong(entryAddress, this.evictionEnabled ? 8L : 0L, value);
    }

    @Override
    public long getLruNode(long entryAddress) {
        return MEMORY.getLong(entryAddress, 0L);
    }

    @Override
    public void setLruNode(long entryAddress, long value) {
        MEMORY.putLong(entryAddress, 0L, value);
    }

    @Override
    public int getHashCode(long entryAddress) {
        int headerOffset = this.evictionEnabled ? 16 : 8;
        return MEMORY.getInt(entryAddress, headerOffset);
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> fromMemory(long address) {
        long lastUsed;
        long created;
        long maxIdle;
        long lifespan;
        int headerOffset;
        int offset = headerOffset = this.evictionEnabled ? 16 : 8;
        int hashCode = MEMORY.getInt(address, offset);
        byte[] keyBytes = new byte[MEMORY.getInt(address, offset += 4)];
        byte[] metadataBytes = new byte[MEMORY.getInt(address, offset += 4)];
        byte[] valueBytes = new byte[MEMORY.getInt(address, offset += 4)];
        byte metadataType = MEMORY.getByte(address, offset += 4);
        MEMORY.getBytes(address, ++offset, keyBytes, 0L, keyBytes.length);
        MEMORY.getBytes(address, offset += keyBytes.length, metadataBytes, 0L, metadataBytes.length);
        MEMORY.getBytes(address, offset += metadataBytes.length, valueBytes, 0L, valueBytes.length);
        offset += valueBytes.length;
        if ((metadataType & 1) == 1) {
            Metadata metadata;
            try {
                metadata = (Metadata)this.marshaller.objectFromByteBuffer(metadataBytes);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException(e);
            }
            return this.internalEntryFactory.create(new WrappedByteArray(keyBytes), new WrappedByteArray(valueBytes), metadata);
        }
        offset = 0;
        boolean hasVersion = (metadataType & 2) == 2;
        switch (metadataType & 0xFC) {
            case 4: {
                lifespan = -1L;
                maxIdle = -1L;
                created = -1L;
                lastUsed = -1L;
                break;
            }
            case 8: {
                maxIdle = -1L;
                lifespan = Bits.getLong(metadataBytes, offset);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = -1L;
                break;
            }
            case 16: {
                lifespan = -1L;
                maxIdle = Bits.getLong(metadataBytes, offset);
                created = -1L;
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                break;
            }
            case 32: {
                lifespan = Bits.getLong(metadataBytes, offset);
                maxIdle = Bits.getLong(metadataBytes, offset += 8);
                created = Bits.getLong(metadataBytes, offset += 8);
                lastUsed = Bits.getLong(metadataBytes, offset += 8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + metadataType);
            }
        }
        if (hasVersion) {
            try {
                EntryVersion version = (EntryVersion)this.marshaller.objectFromByteBuffer(metadataBytes, offset, metadataBytes.length - offset);
                return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), version, created, lifespan, lastUsed, maxIdle);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException(e);
            }
        }
        return this.internalEntryFactory.create(new WrappedByteArray(keyBytes, hashCode), new WrappedByteArray(valueBytes), (Metadata)null, created, lifespan, lastUsed, maxIdle);
    }

    @Override
    public WrappedBytes getKey(long address) {
        long headerOffset = this.evictionEnabled ? 16 : 8;
        int keyLength = MEMORY.getInt(address, headerOffset + 4L);
        byte[] keyBytes = new byte[keyLength];
        MEMORY.getBytes(address, headerOffset + 17L, keyBytes, 0L, keyBytes.length);
        return new WrappedByteArray(keyBytes);
    }

    @Override
    public boolean equalsKey(long address, WrappedBytes wrappedBytes) {
        int headerOffset = this.evictionEnabled ? 16 : 8;
        int hashCode = wrappedBytes.hashCode();
        if (hashCode != MEMORY.getInt(address, headerOffset)) {
            return false;
        }
        int keyLength = MEMORY.getInt(address, headerOffset + 4);
        if (keyLength != wrappedBytes.getLength()) {
            return false;
        }
        for (int i = 0; i < keyLength; ++i) {
            byte b = MEMORY.getByte(address, headerOffset + 17 + i);
            if (b == wrappedBytes.getByte(i)) continue;
            return false;
        }
        return true;
    }
}

