/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;

public class JCacheEventFilteringIterator<K, V>
implements Iterator<CacheEntryEvent<? extends K, ? extends V>> {
    private Iterator<CacheEntryEvent<? extends K, ? extends V>> iterator;
    private CacheEntryEventFilter<? super K, ? super V> filter;
    private CacheEntryEvent<? extends K, ? extends V> nextEntry;

    public JCacheEventFilteringIterator(Iterator<CacheEntryEvent<? extends K, ? extends V>> iterator, CacheEntryEventFilter<? super K, ? super V> filter) {
        this.iterator = iterator;
        this.filter = filter;
        this.nextEntry = null;
    }

    private void fetch() {
        while (this.nextEntry == null && this.iterator.hasNext()) {
            CacheEntryEvent<? extends K, ? extends V> entry = this.iterator.next();
            if (!this.filter.evaluate(entry)) continue;
            this.nextEntry = entry;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextEntry == null) {
            this.fetch();
        }
        return this.nextEntry != null;
    }

    @Override
    public CacheEntryEvent<? extends K, ? extends V> next() {
        if (this.hasNext()) {
            CacheEntryEvent<? extends K, ? extends V> entry = this.nextEntry;
            this.nextEntry = null;
            return entry;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.iterator.remove();
        this.nextEntry = null;
    }
}

