/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent.locks;

import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.Ownership;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;

public class LockUtil {
    private LockUtil() {
    }

    public static Ownership getLockOwnership(Object key, ClusteringDependentLogic clusteringDependentLogic) {
        Object keyToCheck = key instanceof DeltaCompositeKey ? ((DeltaCompositeKey)key).getDeltaAwareValueKey() : key;
        DistributionInfo distributionInfo = clusteringDependentLogic.getCacheTopology().getDistribution(keyToCheck);
        return distributionInfo.writeOwnership();
    }

    public static boolean isLockOwner(Object key, ClusteringDependentLogic clusteringDependentLogic) {
        Object keyToCheck = key instanceof DeltaCompositeKey ? ((DeltaCompositeKey)key).getDeltaAwareValueKey() : key;
        return clusteringDependentLogic.getCacheTopology().getDistribution(keyToCheck).isPrimary();
    }
}

