/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateResponseCommand
extends BaseRpcCommand {
    private static final Log log = LogFactory.getLog(StateResponseCommand.class);
    public static final byte COMMAND_ID = 20;
    private int topologyId;
    private Collection<StateChunk> stateChunks;
    private boolean applyState;
    private StateConsumer stateConsumer;
    private StateReceiver stateReceiver;

    private StateResponseCommand() {
        super(null);
    }

    public StateResponseCommand(ByteString cacheName) {
        super(cacheName);
    }

    public StateResponseCommand(ByteString cacheName, Address origin, int topologyId, Collection<StateChunk> stateChunks) {
        this(cacheName, origin, topologyId, stateChunks, true);
    }

    public StateResponseCommand(ByteString cacheName, Address origin, int topologyId, Collection<StateChunk> stateChunks, boolean applyState) {
        super(cacheName);
        this.setOrigin(origin);
        this.topologyId = topologyId;
        this.stateChunks = stateChunks;
        this.applyState = applyState;
    }

    public void init(StateConsumer stateConsumer, StateReceiver stateReceiver) {
        this.stateConsumer = stateConsumer;
        this.stateReceiver = stateReceiver;
    }

    @Override
    public CompletableFuture<Object> invokeAsync() throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            if (this.applyState) {
                this.stateConsumer.applyState(this.getOrigin(), this.topologyId, this.stateChunks);
            } else {
                this.stateReceiver.receiveState(this.getOrigin(), this.topologyId, this.stateChunks);
            }
            CompletableFuture<Object> completableFuture = CompletableFutures.completedNull();
            return completableFuture;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public byte getCommandId() {
        return 20;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.getOrigin());
        output.writeInt(this.topologyId);
        MarshallUtil.marshallCollection(this.stateChunks, output);
        output.writeBoolean(this.applyState);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.setOrigin((Address)input.readObject());
        this.topologyId = input.readInt();
        this.stateChunks = MarshallUtil.unmarshallCollection(input, ArrayList::new);
        this.applyState = input.readBoolean();
    }

    @Override
    public String toString() {
        return "StateResponseCommand{cache=" + this.cacheName + ", stateChunks=" + this.stateChunks + ", origin=" + this.getOrigin() + ", topologyId=" + this.topologyId + ", applyState=" + this.applyState + '}';
    }
}

