/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;

public class ReadOnlyKeyCommand<K, V, R>
extends AbstractDataCommand {
    public static final int COMMAND_ID = 62;
    protected Function<EntryView.ReadEntryView<K, V>, R> f;
    protected Params params;

    public ReadOnlyKeyCommand(Object key, Function<EntryView.ReadEntryView<K, V>, R> f, Params params) {
        super(key, 0L);
        this.f = f;
        this.params = params;
        this.setFlagsBitSet(params.toFlagsBitSet());
    }

    public ReadOnlyKeyCommand() {
    }

    @Override
    public byte getCommandId() {
        return 62;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.f);
        Params.writeObject(output, this.params);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.f = (Function)input.readObject();
        this.params = Params.readObject(input);
        this.setFlagsBitSet(this.params.toFlagsBitSet());
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry entry = ctx.lookupEntry(this.key);
        if (entry == null) {
            throw new IllegalStateException();
        }
        EntryView.ReadEntryView ro = entry.isNull() ? EntryViews.noValue(this.key) : EntryViews.readOnly(entry);
        R ret = this.f.apply(ro);
        return EntryViews.snapshot(ret);
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadOnlyKeyCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public String toString() {
        return "ReadOnlyKeyCommand{key=" + this.key + ", f=" + this.f + '}';
    }
}

