/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BatchingInterceptor
extends DDAsyncInterceptor {
    private BatchContainer batchContainer;
    private TransactionManager transactionManager;
    private InvocationContextFactory invocationContextFactory;
    private static final Log log = LogFactory.getLog(BatchingInterceptor.class);

    @Inject
    private void inject(BatchContainer batchContainer, TransactionManager transactionManager, InvocationContextFactory invocationContextFactory) {
        this.batchContainer = batchContainer;
        this.transactionManager = transactionManager;
        this.invocationContextFactory = invocationContextFactory;
    }

    @Override
    public Object visitEvictCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
        Transaction tx;
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        if (this.transactionManager.getTransaction() != null || (tx = this.batchContainer.getBatchTransaction()) == null) {
            return this.invokeNext(ctx, command);
        }
        try {
            this.transactionManager.resume(tx);
            if (ctx.isInTxScope()) {
                Object object = this.invokeNext(ctx, command);
                return object;
            }
            log.tracef("Called with a non-tx invocation context: %s", (Object)ctx);
            InvocationContext txInvocationContext = this.invocationContextFactory.createInvocationContext(true, -1);
            Object object = this.invokeNext(txInvocationContext, command);
            return object;
        }
        finally {
            this.suspendTransaction();
        }
    }

    private void suspendTransaction() throws SystemException {
        if (this.transactionManager.getTransaction() != null && this.batchContainer.isSuspendTxAfterInvocation()) {
            this.transactionManager.suspend();
        }
    }
}

