/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.util.RangeSet;

public class ReplicatedConsistentHash
implements ConsistentHash {
    private static final String STATE_PRIMARY_OWNERS = "primaryOwners.%d";
    private static final String STATE_PRIMARY_OWNERS_COUNT = "primaryOwners";
    private final Hash hashFunction;
    private final int[] primaryOwners;
    private final List<Address> members;
    private final Set<Address> membersSet;
    private final Set<Integer> segments;
    private final int segmentSize;

    public ReplicatedConsistentHash(Hash hashFunction, List<Address> members, int[] primaryOwners) {
        this.hashFunction = hashFunction;
        this.members = Collections.unmodifiableList(new ArrayList<Address>(members));
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(members));
        this.primaryOwners = primaryOwners;
        this.segments = new RangeSet(primaryOwners.length);
        this.segmentSize = Util.getSegmentSize(primaryOwners.length);
    }

    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch2) {
        if (!this.getHashFunction().equals(ch2.getHashFunction())) {
            throw new IllegalArgumentException("The consistent hash objects must have the same hash function");
        }
        if (this.getNumSegments() != ch2.getNumSegments()) {
            throw new IllegalArgumentException("The consistent hash objects must have the same number of segments");
        }
        ArrayList<Address> unionMembers = new ArrayList<Address>(this.getMembers());
        for (Address member : ch2.getMembers()) {
            if (unionMembers.contains(member)) continue;
            unionMembers.add(member);
        }
        int[] primaryOwners = new int[this.getNumSegments()];
        for (int segmentId = 0; segmentId < primaryOwners.length; ++segmentId) {
            int primaryOwnerIndex;
            Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
            primaryOwners[segmentId] = primaryOwnerIndex = unionMembers.indexOf(primaryOwner);
        }
        return new ReplicatedConsistentHash(this.getHashFunction(), unionMembers, primaryOwners);
    }

    ReplicatedConsistentHash(ScopedPersistentState state) {
        this.hashFunction = (Hash)Util.getInstance(state.getProperty("hashFunction"), null);
        int numMembers = Integer.parseInt(state.getProperty("members"));
        this.members = new ArrayList<Address>(numMembers);
        for (int i = 0; i < numMembers; ++i) {
            PersistentUUID uuid = PersistentUUID.fromString(state.getProperty(String.format("member.%d", i)));
            this.members.add(uuid);
        }
        this.membersSet = Collections.unmodifiableSet(new HashSet<Address>(this.members));
        int numPrimaryOwners = state.getIntProperty(STATE_PRIMARY_OWNERS_COUNT);
        this.primaryOwners = new int[numPrimaryOwners];
        for (int i = 0; i < numPrimaryOwners; ++i) {
            this.primaryOwners[i] = state.getIntProperty(String.format(STATE_PRIMARY_OWNERS, i));
        }
        this.segments = new RangeSet(this.primaryOwners.length);
        this.segmentSize = Util.getSegmentSize(this.primaryOwners.length);
    }

    @Override
    public int getNumSegments() {
        return this.primaryOwners.length;
    }

    @Override
    public int getNumOwners() {
        return this.members.size();
    }

    @Override
    public List<Address> getMembers() {
        return this.members;
    }

    @Override
    public Hash getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public int getSegment(Object key) {
        return (this.hashFunction.hash(key) & Integer.MAX_VALUE) / this.segmentSize;
    }

    @Override
    public List<Address> locateOwnersForSegment(int segmentId) {
        Address primaryOwner = this.locatePrimaryOwnerForSegment(segmentId);
        ArrayList<Address> owners = new ArrayList<Address>(this.members.size());
        owners.add(primaryOwner);
        for (Address member : this.members) {
            if (member.equals(primaryOwner)) continue;
            owners.add(member);
        }
        return owners;
    }

    @Override
    public Address locatePrimaryOwnerForSegment(int segmentId) {
        return this.members.get(this.primaryOwners[segmentId]);
    }

    @Override
    public Set<Integer> getSegmentsForOwner(Address owner) {
        if (owner == null) {
            throw new IllegalArgumentException("owner cannot be null");
        }
        if (!this.membersSet.contains(owner)) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        return this.segments;
    }

    @Override
    public Set<Integer> getPrimarySegmentsForOwner(Address owner) {
        int index = this.members.indexOf(owner);
        if (index == -1) {
            throw new IllegalArgumentException("The node is not a member : " + owner);
        }
        SmallIntSet primarySegments = new SmallIntSet(this.primaryOwners.length);
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            if (this.primaryOwners[i] != index) continue;
            primarySegments.add(Integer.valueOf(i));
        }
        return primarySegments;
    }

    @Override
    public String getRoutingTableAsString() {
        StringBuilder sb = new StringBuilder();
        for (Address a : this.members) {
            if (sb.length() > 0) {
                sb.append("\n  ");
            }
            Set<Integer> primarySegments = this.getPrimarySegmentsForOwner(a);
            sb.append(a).append(" primary: ").append(primarySegments);
        }
        return sb.toString();
    }

    @Override
    public Set<Address> locateAllOwners(Collection<Object> keys) {
        return this.membersSet;
    }

    @Override
    public boolean isKeyLocalToNode(Address nodeAddress, Object key) {
        return this.isSegmentLocalToNode(nodeAddress, 0);
    }

    @Override
    public boolean isSegmentLocalToNode(Address nodeAddress, int segmentId) {
        return this.membersSet.contains(nodeAddress);
    }

    @Override
    public boolean isReplicated() {
        return true;
    }

    @Override
    public void toScopedState(ScopedPersistentState state) {
        int i;
        state.setProperty("consistentHash", this.getClass().getName());
        state.setProperty("hashFunction", this.hashFunction.getClass().getName());
        state.setProperty("members", Integer.toString(this.members.size()));
        for (i = 0; i < this.members.size(); ++i) {
            state.setProperty(String.format("member.%d", i), this.members.get(i).toString());
        }
        state.setProperty(STATE_PRIMARY_OWNERS_COUNT, Integer.toString(this.primaryOwners.length));
        for (i = 0; i < this.primaryOwners.length; ++i) {
            state.setProperty(String.format(STATE_PRIMARY_OWNERS, i), Integer.toString(this.primaryOwners[i]));
        }
    }

    @Override
    public ConsistentHash remapAddresses(UnaryOperator<Address> remapper) {
        ArrayList<Address> remappedMembers = new ArrayList<Address>(this.members.size());
        Iterator<Address> i = this.members.iterator();
        while (i.hasNext()) {
            Address a = (Address)remapper.apply(i.next());
            if (a == null) {
                return null;
            }
            remappedMembers.add(a);
        }
        return new ReplicatedConsistentHash(this.hashFunction, remappedMembers, this.primaryOwners);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ReplicatedConsistentHash{");
        sb.append("ns = ").append(this.segments.size());
        sb.append(", owners = (").append(this.members.size()).append(")[");
        int[] primaryOwned = new int[this.members.size()];
        for (int i = 0; i < this.primaryOwners.length; ++i) {
            int n = this.primaryOwners[i];
            primaryOwned[n] = primaryOwned[n] + 1;
        }
        boolean first = true;
        for (int i = 0; i < this.members.size(); ++i) {
            Address a = this.members.get(i);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(a).append(": ").append(primaryOwned[i]);
        }
        sb.append("]}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hashFunction == null ? 0 : this.hashFunction.hashCode());
        result = 31 * result + (this.members == null ? 0 : this.members.hashCode());
        result = 31 * result + Arrays.hashCode(this.primaryOwners);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicatedConsistentHash other = (ReplicatedConsistentHash)obj;
        if (this.hashFunction == null ? other.hashFunction != null : !this.hashFunction.equals(other.hashFunction)) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return Arrays.equals(this.primaryOwners, other.primaryOwners);
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ReplicatedConsistentHash> {
        @Override
        public void doWriteObject(ObjectOutput output, ReplicatedConsistentHash ch) throws IOException {
            output.writeObject(ch.hashFunction);
            output.writeObject(ch.members);
            output.writeObject(ch.primaryOwners);
        }

        @Override
        public ReplicatedConsistentHash doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            Hash hashFunction = (Hash)unmarshaller.readObject();
            List members = (List)unmarshaller.readObject();
            int[] primaryOwners = (int[])unmarshaller.readObject();
            return new ReplicatedConsistentHash(hashFunction, members, primaryOwners);
        }

        @Override
        public Integer getId() {
            return 28;
        }

        @Override
        public Set<Class<? extends ReplicatedConsistentHash>> getTypeClasses() {
            return Collections.singleton(ReplicatedConsistentHash.class);
        }
    }
}

