/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;

public class LocalizedCacheTopology
extends CacheTopology {
    private final Address localAddress;
    private final KeyPartitioner keyPartitioner;
    private final boolean isDistributed;
    private final boolean allLocal;
    private final boolean isSegmented;
    private final int numSegments;
    private final int numOwners;
    private final DistributionInfo[] distributionInfos;

    public static LocalizedCacheTopology makeSingletonTopology(CacheMode cacheMode, Address localAddress) {
        List<Address> members = Collections.singletonList(localAddress);
        ReplicatedConsistentHash ch = new ReplicatedConsistentHash(MurmurHash3.getInstance(), members, new int[]{0});
        CacheTopology cacheTopology = new CacheTopology(0, 0, ch, null, CacheTopology.Phase.NO_REBALANCE, members, null);
        return new LocalizedCacheTopology(cacheMode, cacheTopology, key -> 0, localAddress);
    }

    public LocalizedCacheTopology(CacheMode cacheMode, CacheTopology cacheTopology, KeyPartitioner keyPartitioner, Address localAddress) {
        super(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), cacheTopology.getCurrentCH(), cacheTopology.getPendingCH(), cacheTopology.getUnionCH(), cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
        ConsistentHash readCH = this.getReadConsistentHash();
        ConsistentHash writeCH = this.getWriteConsistentHash();
        this.localAddress = localAddress;
        this.keyPartitioner = keyPartitioner;
        this.isDistributed = cacheMode.isDistributed();
        boolean isReplicated = cacheMode.isReplicated();
        this.isSegmented = this.isDistributed || isReplicated;
        this.numSegments = readCH.getNumSegments();
        this.numOwners = readCH.getNumOwners();
        if (this.isDistributed) {
            this.distributionInfos = new DistributionInfo[this.numSegments];
            for (int segmentId = 0; segmentId < this.numSegments; ++segmentId) {
                Address primary = readCH.locatePrimaryOwnerForSegment(segmentId);
                List<Address> readOwners = readCH.locateOwnersForSegment(segmentId);
                List<Address> writeOwners = writeCH.locateOwnersForSegment(segmentId);
                List<Address> writeBackups = writeOwners.subList(1, writeOwners.size());
                this.distributionInfos[segmentId] = new DistributionInfo(segmentId, primary, readOwners, writeOwners, writeBackups, localAddress);
            }
            this.allLocal = false;
        } else if (isReplicated) {
            HashMap<Address, List> readOwnersMap = new HashMap<Address, List>();
            HashMap<Address, List> writeOwnersMap = new HashMap<Address, List>();
            this.distributionInfos = new DistributionInfo[this.numSegments];
            for (int segmentId = 0; segmentId < this.numSegments; ++segmentId) {
                int segmentCopy = segmentId;
                Address primary = readCH.locatePrimaryOwnerForSegment(segmentId);
                List readOwners = readOwnersMap.computeIfAbsent(primary, p -> Immutables.immutableListCopy(readCH.locateOwnersForSegment(segmentCopy)));
                List writeOwners = writeOwnersMap.computeIfAbsent(primary, p -> Immutables.immutableListCopy(writeCH.locateOwnersForSegment(segmentCopy)));
                List<Address> writeBackups = writeOwners.subList(1, writeOwners.size());
                this.distributionInfos[segmentId] = new DistributionInfo(segmentId, primary, readOwners, writeOwners, writeBackups, localAddress);
            }
            this.allLocal = readOwnersMap.containsKey(localAddress);
        } else {
            assert (cacheMode.isInvalidation() || cacheMode == CacheMode.LOCAL);
            List<Address> owners = Collections.singletonList(localAddress);
            List<Address> writeBackups = Collections.emptyList();
            this.distributionInfos = new DistributionInfo[]{new DistributionInfo(0, localAddress, owners, owners, writeBackups, localAddress)};
            this.allLocal = true;
        }
    }

    public boolean isReadOwner(Object key) {
        if (this.allLocal) {
            return true;
        }
        int segmentId = this.keyPartitioner.getSegment(key);
        return this.distributionInfos[segmentId].isReadOwner();
    }

    public boolean isWriteOwner(Object key) {
        if (this.allLocal) {
            return true;
        }
        int segmentId = this.keyPartitioner.getSegment(key);
        return this.distributionInfos[segmentId].isWriteOwner();
    }

    public int getSegment(Object key) {
        return this.keyPartitioner.getSegment(key);
    }

    public DistributionInfo getDistributionForSegment(int segmentId) {
        return this.distributionInfos[segmentId];
    }

    public DistributionInfo getDistribution(Object key) {
        int segmentId = this.isSegmented ? this.keyPartitioner.getSegment(key) : 0;
        return this.distributionInfos[segmentId];
    }

    public Collection<Address> getWriteOwners(Object key) {
        int segmentId = this.isDistributed ? this.keyPartitioner.getSegment(key) : 0;
        return this.distributionInfos[segmentId].writeOwners();
    }

    public Collection<Address> getWriteOwners(Collection<?> keys) {
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.isDistributed) {
            if (keys.size() == 1) {
                Object singleKey = keys.iterator().next();
                return this.getDistribution(singleKey).writeOwners();
            }
            SmallIntSet segments = new SmallIntSet(this.numSegments);
            HashSet<Address> owners = new HashSet<Address>(2 * this.numOwners);
            for (Object key : keys) {
                int segment = this.keyPartitioner.getSegment(key);
                if (!segments.add(segment)) continue;
                owners.addAll(this.getDistributionForSegment(segment).writeOwners());
            }
            return owners;
        }
        return this.getDistributionForSegment(0).writeOwners();
    }

    public Address getLocalAddress() {
        return this.localAddress;
    }
}

