/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.dmr;

import infinispan.org.jboss.dmr.ModelType;
import infinispan.org.jboss.dmr.ModelValue;
import infinispan.org.jboss.dmr.ValueExpression;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;

final class BigDecimalModelValue
extends ModelValue {
    private final BigDecimal value;

    BigDecimalModelValue(BigDecimal value) {
        super(ModelType.BIG_DECIMAL);
        this.value = value;
    }

    BigDecimalModelValue(DataInput in) throws IOException {
        super(ModelType.BIG_DECIMAL);
        this.value = new BigDecimal(in.readUTF());
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.write(ModelType.BIG_DECIMAL.typeChar);
        BigDecimal value = this.value;
        out.writeUTF(value.toString());
    }

    @Override
    long asLong() {
        return this.value.longValue();
    }

    @Override
    long asLong(long defVal) {
        return this.value.longValue();
    }

    @Override
    int asInt() {
        return this.value.intValue();
    }

    @Override
    int asInt(int defVal) {
        return this.value.intValue();
    }

    @Override
    boolean asBoolean() {
        return !this.value.equals(BigDecimal.ZERO);
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return !this.value.equals(BigDecimal.ZERO);
    }

    @Override
    double asDouble() {
        return this.value.doubleValue();
    }

    @Override
    double asDouble(double defVal) {
        return this.value.doubleValue();
    }

    @Override
    BigDecimal asBigDecimal() {
        return this.value;
    }

    @Override
    BigInteger asBigInteger() {
        return this.value.toBigInteger();
    }

    @Override
    String asString() {
        return this.value.toString();
    }

    @Override
    ValueExpression asExpression() {
        return new ValueExpression(this.asString());
    }

    @Override
    void format(PrintWriter writer, int indent, boolean ignored) {
        writer.append("big decimal ");
        writer.append(this.asString());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BigDecimalModelValue && this.equals((BigDecimalModelValue)other);
    }

    public boolean equals(BigDecimalModelValue other) {
        return this == other || other != null && this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

