/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.internal.PrivateGlobalConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;

public class Configurations {
    private Configurations() {
    }

    public static boolean isOnePhaseCommit(Configuration cfg) {
        return !cfg.clustering().cacheMode().isSynchronous() || cfg.transaction().lockingMode() == LockingMode.PESSIMISTIC;
    }

    public static boolean isOnePhaseTotalOrderCommit(Configuration cfg) {
        return cfg.transaction().transactionMode().isTransactional() && cfg.transaction().transactionProtocol().isTotalOrder() && !Configurations.isTxVersioned(cfg);
    }

    public static boolean isTxVersioned(Configuration cfg) {
        return cfg.transaction().transactionMode().isTransactional() && cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC && cfg.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ && !cfg.clustering().cacheMode().isInvalidation();
    }

    public static boolean noDataLossOnJoiner(Configuration configuration) {
        if (!configuration.clustering().cacheMode().isClustered()) {
            return true;
        }
        if (Configurations.hasSharedCacheLoaderOrWriter(configuration)) {
            return true;
        }
        boolean usingStores = configuration.persistence().usingStores();
        boolean passivation = configuration.persistence().passivation();
        boolean fetchInMemoryState = configuration.clustering().stateTransfer().fetchInMemoryState();
        boolean fetchPersistenceState = configuration.persistence().fetchPersistentState();
        return usingStores && !passivation && (fetchInMemoryState || fetchPersistenceState) || usingStores && passivation && fetchInMemoryState && fetchPersistenceState || !usingStores && fetchInMemoryState;
    }

    public static boolean hasSharedCacheLoaderOrWriter(Configuration configuration) {
        for (StoreConfiguration storeConfiguration : configuration.persistence().stores()) {
            if (!storeConfiguration.shared()) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmbeddedMode(GlobalConfiguration globalConfiguration) {
        PrivateGlobalConfiguration config = globalConfiguration.module(PrivateGlobalConfiguration.class);
        return config == null || !config.isServerMode();
    }
}

