/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.functional;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.BiFunction;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.functional.AbstractWriteKeyCommand;
import org.infinispan.commands.functional.Mutation;
import org.infinispan.commands.functional.Mutations;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.api.functional.EntryView;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.functional.impl.EntryViews;
import org.infinispan.functional.impl.Params;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class ReadWriteKeyValueCommand<K, V, R>
extends AbstractWriteKeyCommand<K, V> {
    private static final Log log = LogFactory.getLog(ReadWriteKeyValueCommand.class);
    public static final byte COMMAND_ID = 51;
    private V value;
    private BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f;
    private V prevValue;
    private Metadata prevMetadata;

    public ReadWriteKeyValueCommand(K key, V value, BiFunction<V, EntryView.ReadWriteEntryView<K, V>, R> f, CommandInvocationId id, ValueMatcher valueMatcher, Params params) {
        super(key, valueMatcher, id, params);
        this.value = value;
        this.f = f;
    }

    public ReadWriteKeyValueCommand(ReadWriteKeyValueCommand<K, V, R> other) {
        super(other.getKey(), other.getValueMatcher(), other.commandInvocationId, other.getParams());
        this.value = other.value;
        this.f = other.f;
        this.prevValue = other.prevValue;
        this.prevMetadata = other.prevMetadata;
    }

    public ReadWriteKeyValueCommand() {
    }

    @Override
    public byte getCommandId() {
        return 51;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeObject(this.f);
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        Params.writeObject(output, this.params);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        CommandInvocationId.writeTo(output, this.commandInvocationId);
        output.writeObject(this.prevValue);
        output.writeObject(this.prevMetadata);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.f = (BiFunction)input.readObject();
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.params = Params.readObject(input);
        this.setFlagsBitSet(input.readLong());
        this.commandInvocationId = CommandInvocationId.readFrom(input);
        this.prevValue = input.readObject();
        this.prevMetadata = (Metadata)input.readObject();
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        if (e == null) {
            return null;
        }
        if (this.prevValue == null && !this.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            this.prevValue = e.getValue();
            this.prevMetadata = e.getMetadata();
        }
        Object oldPrevValue = e.getValue();
        Object copy = e.clone();
        R ret = this.f.apply(this.value, EntryViews.readWrite(copy, this.prevValue, this.prevMetadata));
        if (this.valueMatcher.matches(oldPrevValue, this.prevValue, copy.getValue())) {
            log.tracef("Execute read-write function on previous value %s and previous metadata %s", (Object)this.prevValue, (Object)this.prevMetadata);
            e.setValue(copy.getValue());
            e.setMetadata(copy.getMetadata());
            e.setChanged(copy.isChanged());
            e.setRemoved(copy.isRemoved());
            return EntryViews.snapshot(ret);
        }
        return this.f.apply(this.value, EntryViews.readWrite(e, e.getValue(), e.getMetadata()));
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitReadWriteKeyValueCommand(ctx, this);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.OWNER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", prevValue=" + Util.toStr(this.prevValue) + ", prevMetadata=" + Util.toStr(this.prevMetadata) + ", flags=" + this.printFlags() + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", successful=" + this.successful + "}";
    }

    @Override
    public Mutation toMutation(K key) {
        return new Mutations.ReadWriteWithValue<K, V, R>(this.value, this.f);
    }
}

