/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.object.MapIteratorOperation;

public class NoMapIteratorOperation<K, V>
extends MapIteratorOperation<K, V, V> {
    public NoMapIteratorOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
        super(intermediateOperations, supplier, batchSize);
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<V> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<V>> response) {
        BaseStream stream = (BaseStream)this.supplier.get();
        for (IntermediateOperation intOp : this.intermediateOperations) {
            stream = intOp.perform(stream);
        }
        Stream convertedStream = (Stream)stream;
        return this.actualPerformOperation(response, convertedStream);
    }

    private <R> List<R> actualPerformOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<R>> response, Stream<R> stream) {
        BiConsumer<List, Object> accumulator = (l, e) -> {
            l.add(e);
            if (l.size() >= this.batchSize) {
                response.sendDataResonse((Collection)l);
                l.clear();
            }
        };
        List list = stream.collect(ArrayList::new, accumulator, (l1, l2) -> l2.forEach(e -> accumulator.accept((List)l1, e)));
        return list;
    }

    @Override
    public Collection<CacheEntry<K, V>> performOperationRehashAware(KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, V>>> response) {
        Object stream = ((BaseStream)this.supplier.get()).sequential();
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        return this.actualPerformOperation(response, (Stream)stream);
    }
}

