/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.BackupInfo;
import org.rocksdb.BackupableDBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class BackupableDB
extends RocksDB {
    public static BackupableDB open(Options options, BackupableDBOptions backupableDBOptions, String string) throws RocksDBException {
        RocksDB rocksDB = RocksDB.open(options, string);
        BackupableDB backupableDB = new BackupableDB(BackupableDB.open(rocksDB.nativeHandle_, backupableDBOptions.nativeHandle_));
        rocksDB.disOwnNativeHandle();
        return backupableDB;
    }

    public void createNewBackup(boolean bl) throws RocksDBException {
        assert (this.isOwningHandle());
        this.createNewBackup(this.nativeHandle_, bl);
    }

    public void purgeOldBackups(int n) throws RocksDBException {
        assert (this.isOwningHandle());
        this.purgeOldBackups(this.nativeHandle_, n);
    }

    public void deleteBackup(int n) throws RocksDBException {
        assert (this.isOwningHandle());
        this.deleteBackup0(this.nativeHandle_, n);
    }

    public List<BackupInfo> getBackupInfos() {
        assert (this.isOwningHandle());
        return this.getBackupInfo(this.nativeHandle_);
    }

    public int[] getCorruptedBackups() {
        assert (this.isOwningHandle());
        return this.getCorruptedBackups(this.nativeHandle_);
    }

    public void garbageCollect() throws RocksDBException {
        assert (this.isOwningHandle());
        this.garbageCollect(this.nativeHandle_);
    }

    @Override
    public void close() {
        super.close();
    }

    protected BackupableDB(long l) {
        super(l);
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected static native long open(long var0, long var2);

    protected native void createNewBackup(long var1, boolean var3) throws RocksDBException;

    protected native void purgeOldBackups(long var1, int var3) throws RocksDBException;

    private native void deleteBackup0(long var1, int var3) throws RocksDBException;

    protected native List<BackupInfo> getBackupInfo(long var1);

    private native int[] getCorruptedBackups(long var1);

    private native void garbageCollect(long var1) throws RocksDBException;
}

