/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.BackupWriteRcpCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoveCommand
extends AbstractDataWriteCommand {
    private static final Log log = LogFactory.getLog(RemoveCommand.class);
    public static final byte COMMAND_ID = 10;
    protected CacheNotifier<Object, Object> notifier;
    protected boolean successful = true;
    private boolean nonExistent = false;
    protected ValueMatcher valueMatcher;
    protected Object value;

    public RemoveCommand(Object key, Object value, CacheNotifier notifier, long flagsBitSet, CommandInvocationId commandInvocationId) {
        super(key, flagsBitSet, commandInvocationId);
        this.value = value;
        this.notifier = notifier;
        this.valueMatcher = value != null ? ValueMatcher.MATCH_EXPECTED : ValueMatcher.MATCH_ALWAYS;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    public RemoveCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.valueMatcher == ValueMatcher.MATCH_NEVER) {
            this.successful = false;
            return null;
        }
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(this.key);
        Object prevValue = e.getValue();
        if (prevValue == null) {
            this.nonExistent = true;
            if (this.valueMatcher.matches(null, this.value, null)) {
                e.setChanged(true);
                e.setRemoved(true);
                e.setCreated(false);
                if (this instanceof EvictCommand) {
                    e.setEvicted(true);
                }
                e.setValue(null);
                return this.isConditional() ? Boolean.valueOf(true) : null;
            }
            log.trace("Nothing to remove since the entry doesn't exist in the context or it is null");
            this.successful = false;
            return false;
        }
        if (!this.valueMatcher.matches(prevValue, this.value, null)) {
            this.successful = false;
            return false;
        }
        if (this instanceof EvictCommand) {
            e.setEvicted(true);
        }
        return this.performRemove(e, prevValue, ctx);
    }

    public void notify(InvocationContext ctx, Object removedValue, Metadata removedMetadata, boolean isPre) {
        this.notifier.notifyCacheEntryRemoved(this.key, removedValue, removedMetadata, isPre, ctx, this);
    }

    @Override
    public byte getCommandId() {
        return 10;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        RemoveCommand that = (RemoveCommand)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RemoveCommand{key=" + Util.toStr(this.key) + ", value=" + Util.toStr(this.value) + ", flags=" + this.printFlags() + ", commandInvocationId=" + CommandInvocationId.show(this.commandInvocationId) + ", valueMatcher=" + (Object)((Object)this.valueMatcher) + ", topologyId=" + this.getTopologyId() + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.value != null;
    }

    public boolean isNonExistent() {
        return this.nonExistent;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.key);
        output.writeObject(this.value);
        output.writeLong(FlagBitSets.copyWithoutRemotableFlags(this.getFlagsBitSet()));
        MarshallUtil.marshallEnum(this.valueMatcher, output);
        CommandInvocationId.writeTo(output, this.commandInvocationId);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.key = input.readObject();
        this.value = input.readObject();
        this.setFlagsBitSet(input.readLong());
        this.valueMatcher = MarshallUtil.unmarshallEnum(input, ValueMatcher::valueOf);
        this.commandInvocationId = CommandInvocationId.readFrom(input);
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return this.valueMatcher;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
        this.valueMatcher = valueMatcher;
    }

    @Override
    public void updateStatusFromRemoteResponse(Object remoteResponse) {
        if (this.value != null) {
            this.successful = (Boolean)remoteResponse;
        }
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return this.isConditional() || !this.hasAnyFlag(FlagBitSets.IGNORE_RETURN_VALUES) ? VisitableCommand.LoadType.PRIMARY : VisitableCommand.LoadType.DONT_LOAD;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public final boolean isReturnValueExpected() {
        return this.isConditional() || super.isReturnValueExpected();
    }

    @Override
    public void initBackupWriteRcpCommand(BackupWriteRcpCommand command) {
        command.setRemove(this.commandInvocationId, this.key, this.getFlagsBitSet(), this.getTopologyId());
    }

    protected Object performRemove(MVCCEntry e, Object prevValue, InvocationContext ctx) {
        this.notify(ctx, prevValue, e.getMetadata(), true);
        e.setRemoved(true);
        e.setValid(false);
        e.setChanged(true);
        e.setValue(null);
        if (this.valueMatcher != ValueMatcher.MATCH_EXPECTED_OR_NEW) {
            return this.isConditional() ? Boolean.valueOf(true) : prevValue;
        }
        return this.isConditional() ? Boolean.valueOf(true) : this.value;
    }
}

