/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TransactionConfiguration> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final AttributeSet attributes = TransactionConfiguration.attributeDefinitionSet();
    private final RecoveryConfigurationBuilder recovery = new RecoveryConfigurationBuilder(this);

    TransactionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public TransactionConfigurationBuilder autoCommit(boolean b) {
        this.attributes.attribute(TransactionConfiguration.AUTO_COMMIT).set(b);
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l) {
        this.attributes.attribute(TransactionConfiguration.CACHE_STOP_TIMEOUT).set(l);
        return this;
    }

    public TransactionConfigurationBuilder cacheStopTimeout(long l, TimeUnit unit) {
        return this.cacheStopTimeout(unit.toMillis(l));
    }

    @Deprecated
    public TransactionConfigurationBuilder eagerLockingSingleNode(boolean b) {
        this.attributes.attribute(TransactionConfiguration.EAGER_LOCKING_SINGLE_NODE).set(b);
        return this;
    }

    public TransactionConfigurationBuilder lockingMode(LockingMode lockingMode) {
        this.attributes.attribute(TransactionConfiguration.LOCKING_MODE).set(lockingMode);
        return this;
    }

    LockingMode lockingMode() {
        return this.attributes.attribute(TransactionConfiguration.LOCKING_MODE).get();
    }

    @Deprecated
    public TransactionConfigurationBuilder syncCommitPhase(boolean b) {
        return this;
    }

    @Deprecated
    boolean syncCommitPhase() {
        return true;
    }

    @Deprecated
    public TransactionConfigurationBuilder syncRollbackPhase(boolean b) {
        return this;
    }

    public TransactionConfigurationBuilder transactionManagerLookup(TransactionManagerLookup tml) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_MANAGER_LOOKUP).set(tml);
        if (tml != null) {
            this.transactionMode(TransactionMode.TRANSACTIONAL);
        }
        return this;
    }

    public TransactionConfigurationBuilder transactionSynchronizationRegistryLookup(TransactionSynchronizationRegistryLookup lookup) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_SYNCHRONIZATION_REGISTRY_LOOKUP).set(lookup);
        return this;
    }

    public TransactionConfigurationBuilder transactionMode(TransactionMode transactionMode) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).set(transactionMode);
        return this;
    }

    TransactionMode transactionMode() {
        if (this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).isModified()) {
            return this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).get();
        }
        return null;
    }

    @Deprecated
    public TransactionConfigurationBuilder useEagerLocking(boolean b) {
        this.attributes.attribute(TransactionConfiguration.USE_EAGER_LOCKING).set(b);
        return this;
    }

    public TransactionConfigurationBuilder useSynchronization(boolean b) {
        this.attributes.attribute(TransactionConfiguration.USE_SYNCHRONIZATION).set(b);
        return this;
    }

    boolean useSynchronization() {
        return this.attributes.attribute(TransactionConfiguration.USE_SYNCHRONIZATION).get();
    }

    public RecoveryConfigurationBuilder recovery() {
        return this.recovery;
    }

    public TransactionConfigurationBuilder use1PcForAutoCommitTransactions(boolean b) {
        this.attributes.attribute(TransactionConfiguration.USE_1_PC_FOR_AUTO_COMMIT_TRANSACTIONS).set(b);
        return this;
    }

    public TransactionConfigurationBuilder reaperWakeUpInterval(long interval) {
        this.attributes.attribute(TransactionConfiguration.REAPER_WAKE_UP_INTERVAL).set(interval);
        return this;
    }

    public TransactionConfigurationBuilder completedTxTimeout(long timeout) {
        this.attributes.attribute(TransactionConfiguration.COMPLETED_TX_TIMEOUT).set(timeout);
        return this;
    }

    public TransactionConfigurationBuilder transactionProtocol(TransactionProtocol transactionProtocol) {
        this.attributes.attribute(TransactionConfiguration.TRANSACTION_PROTOCOL).set(transactionProtocol);
        return this;
    }

    public TransactionProtocol transactionProtocol() {
        return this.attributes.attribute(TransactionConfiguration.TRANSACTION_PROTOCOL).get();
    }

    public TransactionConfigurationBuilder notifications(boolean enabled) {
        this.attributes.attribute(TransactionConfiguration.NOTIFICATIONS).set(enabled);
        return this;
    }

    @Override
    public void validate() {
        Attribute<Long> reaperWakeUpInterval = this.attributes.attribute(TransactionConfiguration.REAPER_WAKE_UP_INTERVAL);
        Attribute<Long> completedTxTimeout = this.attributes.attribute(TransactionConfiguration.COMPLETED_TX_TIMEOUT);
        if (reaperWakeUpInterval.get() < 0L) {
            throw log.invalidReaperWakeUpInterval(reaperWakeUpInterval.get());
        }
        if (completedTxTimeout.get() < 0L) {
            throw log.invalidCompletedTxTimeout(completedTxTimeout.get());
        }
        CacheMode cacheMode = this.clustering().cacheMode();
        if (this.attributes.attribute(TransactionConfiguration.TRANSACTION_PROTOCOL).get() == TransactionProtocol.TOTAL_ORDER) {
            if (this.transactionMode() != TransactionMode.TRANSACTIONAL) {
                throw log.invalidTxModeForTotalOrder(this.transactionMode());
            }
            if (!cacheMode.isReplicated() && !cacheMode.isDistributed()) {
                throw log.invalidCacheModeForTotalOrder(this.clustering().cacheMode().friendlyCacheModeString());
            }
            if (this.lockingMode() != LockingMode.OPTIMISTIC) {
                throw log.invalidLockingModeForTotalOrder(this.lockingMode());
            }
        }
        if (!this.attributes.attribute(TransactionConfiguration.NOTIFICATIONS).get().booleanValue()) {
            log.transactionNotificationsDisabled();
        }
        if (this.attributes.attribute(TransactionConfiguration.TRANSACTION_MODE).get() == TransactionMode.TRANSACTIONAL && !cacheMode.isSynchronous()) {
            throw log.unsupportedAsyncCacheMode(cacheMode);
        }
        this.recovery.validate();
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.recovery.validate(globalConfig);
    }

    @Override
    public TransactionConfiguration create() {
        if (this.attributes.attribute(TransactionConfiguration.USE_EAGER_LOCKING).get().booleanValue()) {
            this.lockingMode(LockingMode.PESSIMISTIC);
        }
        if (this.transactionMode() == null && this.getBuilder().invocationBatching().isEnabled()) {
            this.transactionMode(TransactionMode.TRANSACTIONAL);
        } else if (this.transactionMode() == null) {
            this.transactionMode(TransactionMode.NON_TRANSACTIONAL);
        }
        return new TransactionConfiguration(this.attributes.protect(), this.recovery.create());
    }

    public TransactionConfigurationBuilder read(TransactionConfiguration template) {
        this.attributes.read(template.attributes());
        this.recovery.read(template.recovery());
        return this;
    }

    public String toString() {
        return "TransactionConfigurationBuilder [attributes=" + this.attributes + ", recovery=" + this.recovery + "]";
    }
}

