/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.filter.KeyFilter;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.stream.impl.local.ValueCacheCollection;

public class DecoratedCache<K, V>
extends AbstractDelegatingAdvancedCache<K, V> {
    private final long flags;
    private final CacheImpl<K, V> cacheImplementation;

    public DecoratedCache(AdvancedCache<K, V> delegate, Flag ... flags) {
        super(delegate);
        if (flags == null) {
            throw new IllegalArgumentException("There is no point in using a DecoratedCache if Flags are set.");
        }
        this.flags = flags.length == 0 ? 0L : EnumUtil.bitSetOf(flags);
        this.cacheImplementation = (CacheImpl)delegate;
    }

    private DecoratedCache(CacheImpl<K, V> delegate, long newFlags) {
        super(delegate);
        this.flags = newFlags;
        this.cacheImplementation = delegate;
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null!");
        }
        return this;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        long newFlags = EnumUtil.bitSetOf(flags);
        if (EnumUtil.containsAll(this.flags, newFlags)) {
            return this;
        }
        return new DecoratedCache<K, V>(this.cacheImplementation, EnumUtil.mergeBitSets(this.flags, newFlags));
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.cacheImplementation.getClassLoader();
    }

    @Override
    public void stop() {
        this.cacheImplementation.stop();
    }

    @Override
    public boolean lock(K ... keys) {
        return this.cacheImplementation.lock((Collection<K>)Arrays.asList(keys), this.flags);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.cacheImplementation.lock(keys, this.flags);
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cacheImplementation.putForExternalRead(key, value, this.flags);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        this.cacheImplementation.putForExternalRead(key, value, metadata, this.flags);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.cacheImplementation.putForExternalRead(key, value, metadata, this.flags);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        this.cacheImplementation.putForExternalRead(key, value, metadata, this.flags);
    }

    @Override
    public void evict(K key) {
        this.cacheImplementation.evict(key, this.flags);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.put(key, value, metadata, this.flags);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        this.cacheImplementation.putAll(map, metadata, this.flags);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replace(key, value, metadata, this.flags);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags);
    }

    @Override
    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.put(key, value, metadata, this.flags);
    }

    @Override
    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        this.cacheImplementation.putAll(map, metadata, this.flags);
    }

    @Override
    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.replace(key, value, metadata, this.flags);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, maxIdleTimeUnit).build();
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value) {
        return this.cacheImplementation.putAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cacheImplementation.putAllAsync(data, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags);
    }

    @Override
    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putAllAsync(data, metadata, this.flags);
    }

    @Override
    public CompletableFuture<Void> clearAsync() {
        return this.cacheImplementation.clearAsync(this.flags);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cacheImplementation.putIfAbsentAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.putIfAbsentAsync(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> removeAsync(Object key) {
        return this.cacheImplementation.removeAsync(key, this.flags);
    }

    @Override
    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cacheImplementation.removeAsync(key, value, this.flags);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.cacheImplementation.replaceAsync(key, value, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.replaceAsync(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, unit).maxIdle(this.cacheImplementation.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS).build();
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.cacheImplementation.replaceAsync(key, oldValue, newValue, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> getAsync(K key) {
        return this.cacheImplementation.getAsync(key, this.flags);
    }

    @Override
    public int size() {
        return this.cacheImplementation.size(this.flags);
    }

    @Override
    public boolean isEmpty() {
        return this.cacheImplementation.isEmpty(this.flags);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cacheImplementation.containsKey(key, this.flags);
    }

    @Override
    public boolean containsValue(Object value) {
        Objects.nonNull(value);
        return this.values().stream().anyMatch(StreamMarshalling.equalityPredicate(value));
    }

    @Override
    public V get(Object key) {
        return this.cacheImplementation.get(key, this.flags);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.cacheImplementation.getAll(keys, this.flags);
    }

    @Override
    public V put(K key, V value) {
        return this.cacheImplementation.put(key, value, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public V remove(Object key) {
        return this.cacheImplementation.remove(key, this.flags);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        this.cacheImplementation.putAll(map, metadata, this.flags);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.cacheImplementation.putAll(m, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public void clear() {
        this.cacheImplementation.clear(this.flags);
    }

    @Override
    public CacheSet<K> keySet() {
        return this.cacheImplementation.keySet(this.flags);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.cacheImplementation.getGroup(groupName, this.flags);
    }

    @Override
    public void removeGroup(String groupName) {
        this.cacheImplementation.removeGroup(groupName, this.flags);
    }

    @Override
    public CacheCollection<V> values() {
        return new ValueCacheCollection<K, V>(this, this.cacheEntrySet());
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cacheImplementation.entrySet(this.flags);
    }

    @Override
    public CacheSet<CacheEntry<K, V>> cacheEntrySet() {
        return this.cacheImplementation.cacheEntrySet(this.flags);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cacheImplementation.putIfAbsent(key, value, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cacheImplementation.remove(key, value, this.flags);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cacheImplementation.replace(key, oldValue, newValue, this.cacheImplementation.defaultMetadata, this.flags);
    }

    @Override
    public V replace(K key, V value) {
        return this.cacheImplementation.replace(key, value, this.cacheImplementation.defaultMetadata, this.flags);
    }

    public long getFlagsBitSet() {
        return this.flags;
    }

    @Override
    public void addListener(Object listener) {
        this.cacheImplementation.notifier.addListener(listener, (ClassLoader)null);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.cacheImplementation.notifier.addListener(listener, filter, null);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.cacheImplementation.put(key, value, metadata, this.flags);
    }

    @Override
    public CompletableFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putAsync(key, value, metadata, this.flags);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        return this.cacheImplementation.putIfAbsent(key, value, metadata, this.flags);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, oldValue, value, metadata, this.flags);
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        return this.cacheImplementation.replace(key, value, metadata, this.flags);
    }

    @Override
    public CacheEntry getCacheEntry(Object key) {
        return this.cacheImplementation.getCacheEntry(key, this.flags);
    }
}

