package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.StackType;
import org.jgroups.util.Util;

import static org.jgroups.tests.bla5.IpType.ipv4;
import static org.jgroups.tests.bla5.IpType.ipv6;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla5 extends ReceiverAdapter {
    protected JChannel ch;
    protected static final String prefer_prop="java.net.preferIPv4Stack";

    protected void start(String name) throws Exception {
        ch=new JChannel("/home/bela/fast.xml").name(name).setReceiver(this).connect("demo");

        int cnt=1;
        IpType ip_type=Util.getIpStackType() == StackType.IPv4? ipv4 : ipv6;
        for(;;) {
            int c=Util.keyPress(String.format("[1] send msg [2] Switch IP (%s) [3] Connect [4] Disconnect", ip_type));
            switch(c) {
                case '1':
                    ch.send(null, "hello-" + cnt++);
                    break;
                case '2':
                    switch(ip_type) {
                        case ipv4:
                            ip_type=ipv6;
                            System.clearProperty(prefer_prop);
                            break;
                        case ipv6:
                            ip_type=ipv4;
                            System.setProperty(prefer_prop, "true");
                            break;
                    }
                    break;
                case '3':
                    if(ch.isClosed())
                        ch=new JChannel("/home/bela/fast.xml").name(name).setReceiver(this).connect("demo");
                    break;
                case '4':
                    Util.close(ch);
                    break;
            }
        }
    }

    public void receive(Message msg) {
        System.out.printf("from %s: %s\n", msg.src(), msg.getObject());
    }

    public void viewAccepted(View view) {
        System.out.println("view = " + view);
    }

    public static void main(String[] args) throws Exception {
        new bla5().start(args[0]);
    }


    enum IpType {ipv4, ipv6}

}
